/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LiteralTableModel
extends AbstractTableModel {
    public static final int COL_VALUE = 0;
    public static final int COL_LANG = 1;
    public static final int COL_TYPE = 1;
    public static final int COL_COUNT = 2;
    private OWLModel owlModel;
    private RDFProperty predicate;
    private Boolean stringProperty = null;
    private RDFResource subject;
    private List values = Collections.EMPTY_LIST;

    public LiteralTableModel(RDFProperty predicate) {
        this.owlModel = predicate.getOWLModel();
        this.predicate = predicate;
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        if (this.isStringProperty()) {
            return String.class;
        }
        return RDFSDatatype.class;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Value";
        }
        if (this.isStringProperty()) {
            return "Lang";
        }
        return "Type";
    }

    protected PropertyValueEditor getEditor(Object value) {
        return PropertyValueEditorManager.getEditor(this.subject, this.predicate, value);
    }

    private Collection getNewValues(int rowOfChangedValue) {
        ArrayList newValues = new ArrayList();
        int i = 0;
        while (i < this.values.size()) {
            Object simpleValue;
            Object value = this.values.get(i);
            if (value instanceof RDFSLiteral && (simpleValue = ((RDFSLiteral)value).getPlainValue()) != null) {
                value = simpleValue;
            }
            if (i == rowOfChangedValue || i != rowOfChangedValue && this.subject.hasPropertyValue(this.predicate, value)) {
                newValues.add(value);
            }
            ++i;
        }
        return newValues;
    }

    public Object getObject(int row) {
        return this.values.get(row);
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    private RDFSLiteral getRDFSLiteral(int rowIndex) {
        return (RDFSLiteral)this.values.get(rowIndex);
    }

    public int getRow(Object value) {
        if (!(value instanceof RDFSLiteral)) {
            value = this.owlModel.createRDFSLiteral(value);
        }
        return this.values.indexOf(value);
    }

    public int getRowCount() {
        return this.values.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Object value = this.getObject(rowIndex);
            if (value instanceof RDFResource) {
                return value;
            }
            RDFSLiteral literal = this.getRDFSLiteral(rowIndex);
            return literal.toString();
        }
        if (this.isStringProperty()) {
            RDFSLiteral literal = this.getRDFSLiteral(rowIndex);
            return literal.getLanguage();
        }
        Object value = this.getObject(rowIndex);
        if (value instanceof RDFResource) {
            return null;
        }
        RDFSLiteral literal = this.getRDFSLiteral(rowIndex);
        return literal.getDatatype();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean active;
        if (this.getObject(rowIndex) instanceof RDFResource) {
            return false;
        }
        RDFSLiteral literal = this.getRDFSLiteral(rowIndex);
        Object v = literal.getPlainValue();
        if (v == null) {
            v = literal;
        }
        if (active = this.owlModel.getTripleStoreModel().isActiveTriple(this.subject, this.predicate, v)) {
            if (columnIndex == 0) {
                if (active) {
                    RDFSLiteral value = this.getRDFSLiteral(rowIndex);
                    PropertyValueEditor editor = this.getEditor(value);
                    return editor == null || !editor.mustEdit(this.subject, this.predicate, value);
                }
            } else {
                if (this.isStringProperty()) {
                    return true;
                }
                return !ComponentUtil.isRangeDefined(this.subject, this.predicate);
            }
        }
        return false;
    }

    public boolean isDeleteEnabled(int[] selectedRows) {
        TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
        boolean deleteEnabled = false;
        if (selectedRows.length > 0) {
            deleteEnabled = true;
            int i = 0;
            while (i < selectedRows.length) {
                int index = selectedRows[i];
                Object object = this.getObject(index);
                if (!tsm.isEditableTriple(this.subject, this.predicate, object)) {
                    deleteEnabled = false;
                }
                ++i;
            }
        }
        return deleteEnabled;
    }

    public boolean isStringProperty() {
        if (this.stringProperty == null) {
            this.stringProperty = new Boolean(this.isStringPropertyHelper());
        }
        return this.stringProperty;
    }

    private boolean isStringPropertyHelper() {
        RDFSDatatype datatype = this.owlModel.getXSDstring();
        if (this.subject != null) {
            Iterator types = this.subject.listRDFTypes();
            while (types.hasNext()) {
                OWLNamedClass cls;
                RDFSClass type = (RDFSClass)types.next();
                if (!(type instanceof OWLNamedClass) || !datatype.equals((cls = (OWLNamedClass)type).getAllValuesFrom(this.predicate))) continue;
                return true;
            }
        }
        return datatype.equals(this.predicate.getRange());
    }

    public void setSubject(RDFResource subject) {
        this.subject = subject;
        this.stringProperty = null;
        this.updateValues();
    }

    private void setTypeAt(Object aValue, int rowIndex) {
        RDFSDatatype datatype = (RDFSDatatype)aValue;
        if (!this.getRDFSLiteral(rowIndex).getDatatype().equals(datatype)) {
            Object newLiteral;
            String lexicalValue = "";
            RDFSLiteral newValue = this.owlModel.createRDFSLiteral(lexicalValue, datatype);
            PropertyValueEditor editor = this.getEditor(newValue);
            if (editor != null && (newLiteral = editor.createDefaultValue(this.subject, this.predicate)) instanceof RDFSLiteral) {
                newValue = (RDFSLiteral)newLiteral;
            }
            this.values.set(rowIndex, newValue);
            this.subject.setPropertyValues(this.predicate, this.getNewValues(rowIndex));
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        RDFSLiteral oldLiteral = this.getRDFSLiteral(rowIndex);
        if (columnIndex == 0) {
            if (aValue instanceof RDFSLiteral) {
                this.values.set(rowIndex, aValue);
            } else {
                String lexicalValue = (String)aValue;
                RDFSDatatype datatype = oldLiteral.getDatatype();
                RDFSLiteral newValue = this.owlModel.createRDFSLiteral(lexicalValue, datatype);
                this.values.set(rowIndex, newValue);
            }
            this.subject.setPropertyValues(this.predicate, this.getNewValues(rowIndex));
        } else if (this.isStringProperty()) {
            this.setLangAt((String)aValue, rowIndex);
        } else {
            this.setTypeAt(aValue, rowIndex);
        }
    }

    private void setLangAt(String value, int rowIndex) {
        String lexicalValue = (String)this.getValueAt(rowIndex, 0);
        Object newValue = (value = value.trim()).length() == 0 ? lexicalValue : this.owlModel.createRDFSLiteral(lexicalValue, value);
        this.values.set(rowIndex, newValue);
        this.subject.setPropertyValues(this.predicate, this.getNewValues(rowIndex));
    }

    public void setValues(Collection newValues) {
        this.values = new ArrayList();
        for (Object value : newValues) {
            if (!(value instanceof RDFResource) && !(value instanceof RDFSLiteral)) {
                value = this.owlModel.createRDFSLiteral(value);
            }
            this.values.add(value);
        }
        this.fireTableDataChanged();
    }

    public void updateValues() {
        if (this.predicate != null && this.subject != null) {
            ArrayList newValues = new ArrayList(this.subject.getPropertyValues(this.predicate, true));
            Collection hasValues = this.subject.getHasValuesOnTypes(this.predicate);
            for (Object hasValue : hasValues) {
                if (newValues.contains(hasValue)) continue;
                newValues.add(hasValue);
            }
            this.setValues(newValues);
        }
    }
}

