/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;

public class DeleteRowTestCase
extends AbstractConditionsTableTestCase {
    public void testRemoveSuperclass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        personCls.addSuperclass(animalCls);
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(2));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(3));
        tableModel.deleteRow(tableModel.getClassRow(animalCls));
        DeleteRowTestCase.assertEquals((int)1, (int)personCls.getSuperclassCount());
        DeleteRowTestCase.assertEquals((Object)this.owlThing, personCls.getSuperclasses(false).iterator().next());
    }

    public void testDeleteOWLThingWithNamedDefinition() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        c.setDefinition(a);
        ConditionsTableModel tableModel = this.getTableModel(c);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", a, NECESSARY, this.owlThing});
        DeleteRowTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(this.owlThing));
        tableModel.deleteRow(3);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", a, NECESSARY});
    }

    public void testDeleteOWLThingWithoutNamedDefinition() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        c.setDefinition(this.owlModel.createOWLComplementClass(a));
        ConditionsTableModel tableModel = this.getTableModel(c);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", OWLComplementClass.class, NECESSARY, this.owlThing});
        DeleteRowTestCase.assertFalse((boolean)tableModel.isDeleteEnabledFor(this.owlThing));
    }

    public void testDeleteSingleAnonEquivalentClass() {
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        parentCls.setDefinition(restriction);
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", restriction, NECESSARY, this.owlThing});
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(0));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(1));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(restriction));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(2));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(3));
        tableModel.deleteRow(tableModel.getClassRow(restriction));
        DeleteRowTestCase.assertEquals((int)0, (int)parentCls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getSuperclassCount());
    }

    public void testDeleteSingleNamedEquivalentClass() {
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("Male");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        cls.setDefinition(maleCls);
        DeleteRowTestCase.assertEquals((int)1, (int)maleCls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        ConditionsTableModel tableModel = this.getTableModel(cls);
        Object[] objectArray = new Object[4];
        objectArray[1] = maleCls;
        objectArray[3] = this.owlThing;
        this.assertTableModelStructure(tableModel, objectArray);
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(0));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(1));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(2));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(3));
        tableModel.deleteRow(1);
        DeleteRowTestCase.assertEquals((int)0, (int)cls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((int)1, (int)cls.getSuperclassCount());
        DeleteRowTestCase.assertEquals((Object)this.owlThing, cls.getSuperclasses(false).iterator().next());
    }

    public void testDeleteAnonOperandFromTupleDefinition() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(restriction);
        parentCls.addSuperclass(animalCls);
        parentCls.removeSuperclass(this.owlThing);
        parentCls.setDefinition(intersectionCls);
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        DeleteRowTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        int i = 0;
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(restriction));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.deleteRow(tableModel.getClassRow(restriction));
        DeleteRowTestCase.assertEquals((int)(oldClsCount - 2), (int)this.owlModel.getClsCount());
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getSuperclassCount());
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((Object)animalCls, (Object)parentCls.getDefinition());
    }

    public void testDeleteNamedOperandFromTupleDefinition() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        String restrictionText = restriction.getBrowserText();
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(restriction);
        parentCls.addSuperclass(animalCls);
        parentCls.removeSuperclass(this.owlThing);
        parentCls.setDefinition(intersectionCls);
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, OWLMinCardinality.class, NECESSARY});
        int i = 0;
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.deleteRow(tableModel.getClassRow(animalCls));
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.owlThing});
        DeleteRowTestCase.assertEquals((int)(oldClsCount - 1), (int)this.owlModel.getClsCount());
        DeleteRowTestCase.assertEquals((int)2, (int)parentCls.getSuperclassCount());
        DeleteRowTestCase.assertEquals((Object)this.owlThing, parentCls.getPureSuperclasses().iterator().next());
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((String)restrictionText, (String)parentCls.getDefinition().getBrowserText());
    }

    public void testDeleteNamedOperandFromTripleDefinition() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        parentCls.addSuperclass(animalCls);
        parentCls.removeSuperclass(this.owlThing);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality minRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLMaxCardinality maxRestriction = this.owlModel.createOWLMaxCardinality(property, 4);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(minRestriction);
        intersectionCls.addOperand(maxRestriction);
        String expectedText = intersectionCls.getBrowserText();
        intersectionCls.addOperand(animalCls);
        parentCls.setDefinition(intersectionCls);
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        DeleteRowTestCase.assertEquals((int)5, (int)tableModel.getRowCount());
        int i = 0;
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(i++));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(minRestriction));
        DeleteRowTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(maxRestriction));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.deleteRow(tableModel.getClassRow(animalCls));
        DeleteRowTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        DeleteRowTestCase.assertEquals((int)2, (int)parentCls.getSuperclassCount());
        DeleteRowTestCase.assertEquals((Object)this.owlThing, parentCls.getPureSuperclasses().iterator().next());
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        DeleteRowTestCase.assertEquals((String)expectedText, (String)parentCls.getDefinition().getBrowserText());
    }

    public void testDeleteAnonOperandFromTripleDefinition() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        parentCls.addSuperclass(animalCls);
        parentCls.removeSuperclass(this.owlThing);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality minRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLMaxCardinality maxRestriction = this.owlModel.createOWLMaxCardinality(property, 4);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(minRestriction);
        String expectedText = intersectionCls.getBrowserText();
        intersectionCls.addOperand(maxRestriction);
        parentCls.setDefinition(intersectionCls);
        DeleteRowTestCase.assertEquals((int)1, (int)parentCls.getEquivalentClasses().size());
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, OWLMinCardinality.class, OWLMaxCardinality.class, NECESSARY});
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.deleteRow(3);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", animalCls, OWLMinCardinality.class, NECESSARY});
        DeleteRowTestCase.assertEquals((String)expectedText, (String)parentCls.getDefinition().getBrowserText());
    }

    public void testAldi() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("Male");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        cls.addEquivalentClass(maleCls);
        cls.removeSuperclass(this.owlThing);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(maleCls);
        intersectionCls.addOperand(this.owlModel.createOWLMinCardinality(property, 1));
        cls.addEquivalentClass(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        Object[] objectArray = new Object[6];
        objectArray[1] = maleCls;
        objectArray[2] = OWLMinCardinality.class;
        objectArray[4] = maleCls;
        this.assertTableModelStructure(tableModel, objectArray);
        tableModel.deleteRow(1);
        Object[] objectArray2 = new Object[5];
        objectArray2[1] = maleCls;
        objectArray2[3] = OWLMinCardinality.class;
        this.assertTableModelStructure(tableModel, objectArray2);
    }

    public void testDeleteOnlySuperclass() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschClass = this.owlModel.createOWLNamedClass("Mensch");
        personClass.addEquivalentClass(menschClass);
        menschClass.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(personClass);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", menschClass, NECESSARY, this.owlThing});
        tableModel.deleteRow(1);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        DeleteRowTestCase.assertSize(1, menschClass.getSuperclasses(false));
        DeleteRowTestCase.assertEquals((Object)personClass, menschClass.getSuperclasses(false).iterator().next());
    }

    public void testIsRemoveEnabledInMixedClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLNamedClass dc = this.owlModel.createOWLNamedClass("Other");
        OWLIntersectionClass in = this.owlModel.createOWLIntersectionClass();
        in.addOperand(dc);
        in.addOperand(this.owlModel.createOWLComplementClass(dc));
        cls.setDefinition(in);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", dc, OWLComplementClass.class, NECESSARY, this.owlThing});
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(4));
    }

    public void testDeleteLastNamedSuperclass() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass c = this.owlModel.createOWLNamedSubclass("Class", superclass);
        c.addSuperclass(this.owlModel.createOWLComplementClass(superclass));
        ConditionsTableModel tableModel = this.getTableModel(c);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superclass, OWLComplementClass.class});
        DeleteRowTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(2));
        tableModel.deleteRow(2);
        DeleteRowTestCase.assertSize(2, c.getSuperclasses(false));
        DeleteRowTestCase.assertContains((Object)this.owlThing, c.getSuperclasses(false));
    }

    public void testDeleteLastNamedSuperclassOWLThing() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        c.addSuperclass(this.owlModel.createOWLComplementClass(c));
        ConditionsTableModel tableModel = this.getTableModel(c);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, OWLComplementClass.class});
        DeleteRowTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(2));
    }
}

