/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class RepositoryEntryLabel
extends JLabel {
    private URI name;
    private Action copyToClipboardAction;
    private Action downloadToLocalFileAction;
    private OWLModel model;

    public RepositoryEntryLabel(OWLModel model, URI name, String locationDescription, boolean imported) {
        this.name = name;
        this.model = model;
        this.setIconTextGap(20);
        String colour = "";
        colour = imported ? "rgb(90, 50, 180)" : "rgb(20, 20, 20)";
        String html = "<html><body>&nbsp;&nbsp;<font color=\"" + colour + "\">" + name + "</font> <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"rgb(100, 100, 100)\" size=\"-2\">(" + locationDescription + ")</font></body></html>";
        this.setText(html);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.copyToClipboardAction = new AbstractAction("Copy to clipboard"){

            public void actionPerformed(ActionEvent e) {
                StringSelection sel = new StringSelection(RepositoryEntryLabel.this.name.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
            }
        };
        this.downloadToLocalFileAction = new AbstractAction("Copy to local file..."){

            public void actionPerformed(ActionEvent e) {
                RepositoryEntryLabel.this.copyToLocalFile();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            private void showPopupMenu(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(RepositoryEntryLabel.this.copyToClipboardAction);
                    menu.add(RepositoryEntryLabel.this.downloadToLocalFileAction);
                    menu.show(RepositoryEntryLabel.this, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                this.showPopupMenu(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.showPopupMenu(e);
            }
        });
    }

    private void copyToLocalFile() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            try {
                RepositoryUtil.createImportLocalCopy(this.model, this.name, f);
            }
            catch (IOException e) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.model, e.getMessage());
            }
        }
    }
}

