/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.tidy.impl.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.impl.Blank;
import com.hp.hpl.jena.ontology.tidy.impl.CGeneral;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.One;
import com.hp.hpl.jena.ontology.tidy.impl.SyntaxProblemImpl;
import com.hp.hpl.jena.ontology.tidy.impl.Two;
import com.hp.hpl.jena.rdf.model.ModelFactory;

class OneTwoImpl
extends CGeneral
implements One,
Two,
Blank {
    private Triple[] seen = new Triple[3];
    private boolean stripped = false;
    private static String[] shortMsg = new String[]{"Illegal description/restriction/list/alldifferent structure", "Illegal restriction/list structure", "Node may not be object of multiple triples"};
    protected int cyclicState = 0;
    protected static final int Checking = 1;
    protected static final int Undefined = 0;
    protected static final int IsCyclic = 2;
    protected static final int NonCyclic = 3;

    void getSeen(Triple[] tripleArray) {
        tripleArray[0] = this.seen[0];
        tripleArray[1] = this.seen[1];
        tripleArray[2] = this.seen[2];
    }

    void setSeen(Triple[] tripleArray) {
        this.seen[0] = tripleArray[0];
        this.seen[1] = tripleArray[1];
        this.seen[2] = tripleArray[2];
    }

    OneTwoImpl(Node node, AbsChecker absChecker) {
        super(node, absChecker);
        if (this.getCategories() == -1) {
            this.setCategories(Grammar.blank, false);
        }
    }

    public void first(Triple triple) {
        this.check(0, triple);
    }

    public void second(Triple triple) {
        this.check(1, triple);
    }

    void check(int n, Triple triple) {
        Triple triple2 = this.get(n);
        if (triple2 != null) {
            if (triple2.equals((Object)triple)) {
                return;
            }
            Graph graph = ModelFactory.createDefaultModel().getGraph();
            graph.add(triple2);
            graph.add(triple);
            this.getChecker().addProblem(new SyntaxProblemImpl(shortMsg[n], graph, 2));
        } else {
            this.seen[n] = triple;
        }
    }

    Triple get(int n) {
        return this.seen[n];
    }

    boolean incomplete(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.get(i) != null) continue;
            return true;
        }
        return false;
    }

    public void addObjectTriple(Triple triple) {
        this.check(2, triple);
    }

    protected int getCyclicState() {
        return this.cyclicState;
    }

    protected void setCyclicState(int n) {
        this.cyclicState = n;
        this.checker.cyclicTouched.add(this);
    }

    public boolean incompleteOne() {
        return this.incomplete(1);
    }

    public boolean incompleteTwo() {
        return this.incomplete(2);
    }

    public void strip(boolean bl) {
        this.seen[0] = null;
        this.seen[1] = null;
        if (!bl) {
            this.seen[2] = null;
        }
        this.stripped = true;
    }

    public boolean stripped() {
        return this.stripped;
    }
}

