/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SubpropertyDomainMustNarrowTest
extends AbstractOWLTest
implements RDFPropertyTest {
    public SubpropertyDomainMustNarrowTest() {
        super("Sanity Tests", "Domain of a subproperty can only narrow superproperty");
    }

    public static OWLObjectProperty fails(OWLObjectProperty objectProperty) {
        Collection domain = objectProperty.getUnionDomain();
        for (RDFProperty superproperty : objectProperty.getSuperproperties(true)) {
            Collection superDomain;
            if (!(superproperty instanceof OWLObjectProperty) || (superDomain = superproperty.getUnionDomain()).isEmpty() && superproperty.getSuperpropertyCount() != 0 || SubpropertyDomainMustNarrowTest.isSubClasses(superDomain, domain)) continue;
            return (OWLObjectProperty)superproperty;
        }
        return null;
    }

    private static boolean isSubClasses(Collection superDomain, Collection subDomain) {
        for (RDFSClass subCls : subDomain) {
            if (!(subCls instanceof RDFSNamedClass)) continue;
            boolean hasSuperCls = false;
            for (RDFSClass superCls : superDomain) {
                if (!(superCls instanceof RDFSNamedClass) || !subCls.equals(superCls) && !subCls.getSuperclasses(true).contains(superCls)) continue;
                hasSuperCls = true;
                break;
            }
            if (hasSuperCls) continue;
            return false;
        }
        return true;
    }

    public List test(RDFProperty property) {
        OWLObjectProperty failProperty;
        if (property instanceof OWLObjectProperty && (failProperty = SubpropertyDomainMustNarrowTest.fails((OWLObjectProperty)property)) != null) {
            return Collections.singletonList(new DefaultOWLTestResult("The domain of " + property.getBrowserText() + " is not a subset of the domain of its superproperty " + failProperty.getBrowserText() + ".", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

