/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.TaskProgressDisplay;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ProgressDisplayDialog
extends JDialog
implements TaskProgressDisplay {
    private static final int DISPLAY_DELAY = 3000;
    private Box box;
    private Map taskProgressPanelMap = new HashMap();
    private NullTaskDisplay nullTaskDisplay = new NullTaskDisplay();
    private Map subTaskTimers = new HashMap();

    public ProgressDisplayDialog() {
        super(ProgressDisplayDialog.getOwnerFrame(), true);
        this.setDefaultCloseOperation(0);
        this.createUI();
    }

    private static Frame getOwnerFrame() {
        Component c;
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        if (project != null && (c = ProtegeUI.getTopLevelContainer(project)) instanceof Frame) {
            return (Frame)c;
        }
        return null;
    }

    private void createUI() {
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        JLabel iconLabel = new JLabel(UIManager.getDefaults().getIcon("OptionPane.informationIcon"));
        JPanel iconLabelHolder = new JPanel(new BorderLayout());
        iconLabelHolder.add((Component)iconLabel, "North");
        panel.add((Component)iconLabelHolder, "West");
        this.box = new Box(1);
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.add((Component)this.box, "Center");
        this.setContentPane(panel);
        this.pack();
    }

    public void run(final Task task) throws Exception {
        final ProgressPanel pp = new ProgressPanel(task);
        this.taskProgressPanelMap.put(task, pp);
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProgressDisplayDialog.this.taskProgressPanelMap.size() > 1) {
                    Timer t = new Timer(3000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ProgressDisplayDialog.this.box.add(pp);
                            ProgressDisplayDialog.this.pack();
                            ProgressDisplayDialog.this.subTaskTimers.remove(task);
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                    ProgressDisplayDialog.this.subTaskTimers.put(task, t);
                } else {
                    ProgressDisplayDialog.this.box.add(pp);
                    ProgressDisplayDialog.this.pack();
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
        this.runTask(task);
    }

    private void runTask(final Task task) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        task.runTask();
                        ProgressDisplayDialog.this.end(task);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            t.start();
            this.displayProgressDialog();
        } else {
            task.runTask();
            this.end(task);
        }
    }

    private void displayProgressDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("[ProgressDisplayDialog] displayOrBlock should only be called from the event dispatch thread!");
        }
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < 3000L) {
        }
        if (this.taskProgressPanelMap.size() > 0) {
            this.centreDialog();
            this.setVisible(true);
        }
    }

    private ProgressPanel getProgressPanel(Task task) {
        ProgressPanel pp = (ProgressPanel)this.taskProgressPanelMap.get(task);
        return pp;
    }

    private TaskDisplay getTaskDisplay(Task task) {
        TaskDisplay display = this.getProgressPanel(task);
        if (display == null) {
            display = this.nullTaskDisplay;
        }
        return display;
    }

    public void setProgress(final Task task, final int progress) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setProgress(progress);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setProgressIndeterminate(final Task task, final boolean b) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setProgressIndeterminate(b);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setMessage(final Task task, final String message) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setMessage(message);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void end(final Task task) {
        Timer timer = (Timer)this.subTaskTimers.get(task);
        if (timer != null) {
            timer.stop();
        }
        this.subTaskTimers.remove(task);
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressPanel pp = ProgressDisplayDialog.this.getProgressPanel(task);
                if (pp != null) {
                    ProgressDisplayDialog.this.taskProgressPanelMap.remove(task);
                    ProgressDisplayDialog.this.box.remove(pp);
                    ProgressDisplayDialog.this.pack();
                }
                if (ProgressDisplayDialog.this.taskProgressPanelMap.size() == 0) {
                    ProgressDisplayDialog.this.setVisible(false);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void centreDialog() {
        Dimension size = this.getToolkit().getScreenSize();
        this.setLocation(size.width / 2 - this.getWidth() / 2, size.height / 2 - this.getHeight() / 2);
    }

    private class ProgressPanel
    extends JPanel
    implements TaskDisplay {
        private JLabel titleLabel;
        private JLabel msgLabel;
        private JProgressBar progressBar;
        public static final int INDENT = 20;

        public ProgressPanel(Task task) {
            this.setLayout(new BorderLayout(7, 7));
            this.setBorder(BorderFactory.createEmptyBorder(10, ProgressDisplayDialog.this.taskProgressPanelMap.size() == 0 ? 0 : 20, 5, 0));
            JPanel labelPanel = new JPanel(new BorderLayout(3, 3));
            this.titleLabel = new JLabel(task.getTitle());
            labelPanel.add((Component)this.titleLabel, "North");
            this.msgLabel = new JLabel("");
            this.msgLabel.setFont(this.msgLabel.getFont().deriveFont(this.msgLabel.getFont().getSize2D() * 0.8f));
            this.msgLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            labelPanel.add((Component)this.msgLabel, "South");
            this.add((Component)labelPanel, "North");
            this.progressBar = new JProgressBar(task.getProgressMin(), task.getProgressMax());
            this.progressBar.setIndeterminate(true);
            JPanel progressBarHolder = new JPanel(new BorderLayout(7, 7));
            progressBarHolder.add((Component)this.progressBar, "North");
            progressBarHolder.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.add((Component)progressBarHolder, "South");
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color oldColor = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(5, this.getHeight() - 2, this.getWidth() - 5, this.getHeight() - 2);
            g.setColor(oldColor);
        }

        public void setMessage(String message) {
            this.msgLabel.setText(message);
        }

        public void setProgress(int progress) {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue(progress);
        }

        public void setProgressIndeterminate(boolean b) {
            this.progressBar.setIndeterminate(b);
        }
    }

    private class NullTaskDisplay
    implements TaskDisplay {
        private NullTaskDisplay() {
        }

        public void setProgress(int progress) {
        }

        public void setProgressIndeterminate(boolean b) {
        }

        public void setMessage(String message) {
        }
    }

    private static interface TaskDisplay {
        public void setProgress(int var1);

        public void setProgressIndeterminate(boolean var1);

        public void setMessage(String var1);
    }
}

