/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBindingImpl;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestsMisc
extends TestSuite {
    static final String testSetName = "RDQL - Query - Other";
    public static String baseURI = "http://rdql/";

    public static TestSuite suite() {
        return new QueryTestsMisc(testSetName);
    }

    private QueryTestsMisc(String string) {
        super(string);
        try {
            this.addTest((Test)new TestQueryTriplesMerge());
            this.addTest((Test)new TestQueryGetTriples());
            this.addTest((Test)new TestQueryGetTriples2());
        }
        catch (Exception exception) {
            System.err.println("Problems making RDQL test");
            exception.printStackTrace(System.err);
            return;
        }
    }

    static class TestQueryGetTriples2
    extends TestQueryTriples {
        TestQueryGetTriples2() {
            super("TestQueryGetTriples2");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            int n = 0;
            while (queryResults.hasNext()) {
                ResultBindingImpl resultBindingImpl = (ResultBindingImpl)queryResults.next();
                Set set = resultBindingImpl.getTriples();
                TestQueryGetTriples2.assertTrue((String)(this.getName() + ": getTriples2(loop " + ++n + ")"), (resultBindingImpl.getTriples().size() == 1 ? 1 : 0) != 0);
            }
            queryResults.close();
        }
    }

    static class TestQueryGetTriples
    extends TestQueryTriples {
        TestQueryGetTriples() {
            super("TestQueryGetTriples");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            int n = 0;
            while (queryResults.hasNext()) {
                ResultBindingImpl resultBindingImpl = (ResultBindingImpl)queryResults.next();
                TestQueryGetTriples.assertTrue((String)(this.getName() + ": getTriples(loop " + ++n + ")"), (resultBindingImpl.getTriples().size() == 1 ? 1 : 0) != 0);
            }
            queryResults.close();
        }
    }

    static class TestQueryTriplesMerge
    extends TestQueryTriples {
        TestQueryTriplesMerge() {
            super("TestQueryTriplesMerge");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            while (queryResults.hasNext()) {
                ResultBindingImpl resultBindingImpl = (ResultBindingImpl)queryResults.next();
                resultBindingImpl.mergeTriples(model);
            }
            queryResults.close();
            TestQueryTriplesMerge.assertTrue((String)(this.getName() + ": merged rsults not the same as target model"), (boolean)this.model.isIsomorphicWith(model));
        }
    }

    static abstract class TestQueryTriples
    extends TestCase {
        Model model = ModelFactory.createDefaultModel();
        Resource r = this.model.createResource(baseURI + "r");

        TestQueryTriples(String string) {
            super(string);
            this.r.addProperty(this.model.createProperty(baseURI + "p1"), "v1");
            this.r.addProperty(this.model.createProperty(baseURI + "p2"), "v2");
        }
    }
}

