/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Restriction;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;

public class CreateCardinalityRestrictionsTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateCardinalityRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        cls.addSuperclass(this.owlModel.createOWLCardinality(property, 4));
        OntModel ontModel = this.createOntModel();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateCardinalityRestrictionsTestCase.assertTrue((boolean)r.canAs(CardinalityRestriction.class));
        CardinalityRestriction cr = r.asCardinalityRestriction();
        CreateCardinalityRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)cr.getOnProperty());
        CreateCardinalityRestrictionsTestCase.assertEquals((int)4, (int)cr.getCardinality());
    }

    public void testCreateMaxCardinalityRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        cls.addSuperclass(this.owlModel.createOWLMaxCardinality(property, 4));
        OntModel ontModel = this.createOntModel();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateCardinalityRestrictionsTestCase.assertTrue((boolean)r.canAs(MaxCardinalityRestriction.class));
        MaxCardinalityRestriction cr = r.asMaxCardinalityRestriction();
        CreateCardinalityRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)cr.getOnProperty());
        CreateCardinalityRestrictionsTestCase.assertEquals((int)4, (int)cr.getMaxCardinality());
    }

    public void testCreateMinCardinalityRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 4));
        OntModel ontModel = this.createOntModel();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateCardinalityRestrictionsTestCase.assertTrue((boolean)r.canAs(MinCardinalityRestriction.class));
        MinCardinalityRestriction cr = r.asMinCardinalityRestriction();
        CreateCardinalityRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)cr.getOnProperty());
        CreateCardinalityRestrictionsTestCase.assertEquals((int)4, (int)cr.getMinCardinality());
    }
}

