/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;

public class LoadDuplicateAnonymousSuperclassTestCase
extends AbstractJenaTestCase {
    public void testLoadDuplicateRestriction() throws Exception {
        OWLNamedClass oldClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty oldProperty = this.owlModel.createOWLObjectProperty("oldProperty");
        oldClass.addSuperclass(this.owlModel.createOWLMinCardinality(oldProperty, 1));
        oldClass.addSuperclass(this.owlModel.createOWLMinCardinality(oldProperty, 1));
        LoadDuplicateAnonymousSuperclassTestCase.assertSize(3, oldClass.getSuperclasses(false));
        JenaOWLModel newModel = LoadDuplicateAnonymousSuperclassTestCase.reload(this.owlModel);
        OWLNamedClass newClass = newModel.getOWLNamedClass(oldClass.getName());
        ArrayList superclasses = new ArrayList(newClass.getSuperclasses(false));
        LoadDuplicateAnonymousSuperclassTestCase.assertSize(2, superclasses);
        superclasses.remove(newModel.getOWLThingClass());
        LoadDuplicateAnonymousSuperclassTestCase.assertSize(1, superclasses);
        OWLMinCardinality newRestriction = (OWLMinCardinality)superclasses.iterator().next();
        LoadDuplicateAnonymousSuperclassTestCase.assertEquals((int)1, (int)newRestriction.getCardinality());
    }
}

