/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.clips.ClipsFilesExportProjectPlugin;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClipsExportToNewFormatWizardPage
extends WizardPage {
    private FileField projectFileField;
    private JTextField clsesFileField;
    private JTextField instancesFileField;
    private ClipsFilesExportProjectPlugin plugin;

    public ClipsExportToNewFormatWizardPage(Wizard wizard, Project project, ClipsFilesExportProjectPlugin clipsFilesExportProjectPlugin) {
        super("clips export", wizard);
        this.plugin = clipsFilesExportProjectPlugin;
        this.createComponents(null);
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents(File file) {
        this.projectFileField = new FileField("Project (.pprj) File", null, ".pprj", "Project File");
        this.clsesFileField = ComponentFactory.createTextField();
        this.clsesFileField.setEnabled(false);
        this.instancesFileField = ComponentFactory.createTextField();
        this.instancesFileField.setEnabled(false);
        this.projectFileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ClipsExportToNewFormatWizardPage.this.onProjectFieldChanged();
                ClipsExportToNewFormatWizardPage.this.updateSetPageComplete();
            }
        });
    }

    private void onProjectFieldChanged() {
        String string = this.getProjectFileName();
        ClipsExportToNewFormatWizardPage.replaceName(this.instancesFileField, ".pins", string);
        ClipsExportToNewFormatWizardPage.replaceName(this.clsesFileField, ".pont", string);
    }

    private static void replaceName(JTextField jTextField, String string, String string2) {
        String string3 = FileUtilities.replaceExtension(string2, string);
        string3 = new File(string3).getName();
        jTextField.setText(string3);
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.getProjectFileName() != null);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(this.projectFileField);
        box.add(new LabeledComponent("Classes (.pont) File", this.clsesFileField));
        box.add(new LabeledComponent("Instances (.pins) File", this.instancesFileField));
        this.add((Component)box, "North");
    }

    public void onFinish() {
        String string = this.getProjectFileName();
        String string2 = this.clsesFileField.getText();
        String string3 = this.instancesFileField.getText();
        this.plugin.setNewProjectPath(string);
        this.plugin.setFiles(string2, string3);
    }

    private String getProjectFileName() {
        return ClipsExportToNewFormatWizardPage.getPath(this.projectFileField, ".pprj");
    }

    private static String getPath(FileField fileField, String string) {
        String string2 = fileField.getPath();
        return FileUtilities.ensureExtension(string2, string);
    }
}

