/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.query.protege.dig;

import de.uka.cmtm.serviceregistry.query.protege.ParameterConformClasses;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualInfo;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualLocator;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualParameter;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DefaultDIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGTranslator;
import edu.stanford.smi.protegex.owl.inference.protegeowl.DefaultProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigProfileIndividualLocator
implements ProfileIndividualLocator {
    private static final Log log = LogFactory.getLog(DigProfileIndividualLocator.class);
    private static final String PROFILES_QUERY_ID = "profiles";
    private final String upperServiceOntologyPrefix;
    private final String topOntologyPrefix;
    private final OWLObjectProperty preconditionProperty;
    private final OWLObjectProperty effectProperty;
    private final OWLObjectProperty logicalInputProperty;
    private final OWLObjectProperty logicalOutputProperty;
    private final OWLObjectProperty userRoleProperty;
    private final OWLDatatypeProperty textDescriptionProperty;
    private final OWLClass serviceProfileClass;
    private ProtegeOWLReasoner owlReasoner;
    private DefaultDIGReasoner digReasoner;
    private DefaultDIGTranslator digTranslator;
    private Map<OWLClass, Collection<OWLClass>> ancestors = new HashMap<OWLClass, Collection<OWLClass>>();
    private Map<OWLClass, Collection<OWLClass>> descendants = new HashMap<OWLClass, Collection<OWLClass>>();
    private ProfileIndividualParameter requiredClasses;
    private Map<OWLClass, Collection<OWLClass>> preconditionAncestors = new HashMap<OWLClass, Collection<OWLClass>>();
    private Map<OWLClass, Collection<OWLClass>> logicalInputAncestors = new HashMap<OWLClass, Collection<OWLClass>>();
    private ProfileIndividualParameter piParameter;
    private ParameterConformClasses conformClasses;
    private OWLModel owlModel;
    private int expectedSearchLevel = 0;

    public DigProfileIndividualLocator(OWLModel owlModel, String digReasonerUrl, String upperServiceOntologyUrl, String topOntologyUrl) {
        this.owlModel = owlModel;
        RDFResource upperServiceOntology = null;
        RDFResource topOntology = null;
        try {
            ReasonerManager reasonerManager = ReasonerManager.getInstance();
            this.owlReasoner = reasonerManager.getReasoner(owlModel);
            this.owlReasoner.setURL(digReasonerUrl);
            if (!this.owlReasoner.isConnected()) {
                throw new IllegalStateException("OWL-Reasoner not available.");
            }
            log.info((Object)("Connected to " + this.owlReasoner.getIdentity().getName()));
            log.debug((Object)"Synchronizing ontology with reasoner");
            ((DefaultProtegeOWLReasoner)this.owlReasoner).synchronizeReasoner(null);
            this.digReasoner = (DefaultDIGReasoner)this.owlReasoner.getDIGReasoner();
            this.digTranslator = (DefaultDIGTranslator)this.digReasoner.getTranslator();
            upperServiceOntology = owlModel.getOWLOntologyByURI(new URI(upperServiceOntologyUrl));
            log.trace((Object)("Found upper ontology: " + (upperServiceOntology == null ? "none" : upperServiceOntology.getURI())));
            topOntology = owlModel.getOWLOntologyByURI(new URI(topOntologyUrl));
            log.trace((Object)("Found top ontology: " + (topOntology == null ? "none" : topOntology.getURI())));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot synchronize ontology with reasoner.", e);
        }
        if (upperServiceOntology == null) {
            throw new IllegalArgumentException("Upper ontology not present.");
        }
        this.upperServiceOntologyPrefix = String.valueOf(upperServiceOntology.getNamespacePrefix()) + ":";
        log.trace((Object)("Found upper ontology prefix: " + this.upperServiceOntologyPrefix));
        if (topOntology == null) {
            throw new IllegalArgumentException("Top ontology not present.");
        }
        this.topOntologyPrefix = String.valueOf(topOntology.getNamespacePrefix()) + ":";
        log.trace((Object)("Found top ontology prefix: " + this.topOntologyPrefix));
        this.preconditionProperty = owlModel.getOWLObjectProperty(String.valueOf(this.upperServiceOntologyPrefix) + "precondition");
        if (this.preconditionProperty == null) {
            throw new IllegalArgumentException("preconditionProperty not present.");
        }
        log.trace((Object)("Found preconditionProperty: " + this.preconditionProperty.getName()));
        this.effectProperty = owlModel.getOWLObjectProperty(String.valueOf(this.upperServiceOntologyPrefix) + "effect");
        if (this.effectProperty == null) {
            throw new IllegalArgumentException("effectProperty not present.");
        }
        log.trace((Object)("Found effectProperty: " + this.effectProperty.getName()));
        this.logicalInputProperty = owlModel.getOWLObjectProperty(String.valueOf(this.upperServiceOntologyPrefix) + "logicalInput");
        if (this.logicalInputProperty == null) {
            throw new IllegalArgumentException("logicalInputProperty not present.");
        }
        log.trace((Object)("Found logicalInputProperty: " + this.logicalInputProperty.getName()));
        this.logicalOutputProperty = owlModel.getOWLObjectProperty(String.valueOf(this.upperServiceOntologyPrefix) + "logicalOutput");
        if (this.logicalOutputProperty == null) {
            throw new IllegalArgumentException("logicalOutputProperty not present.");
        }
        log.trace((Object)("Found logicalOutputProperty: " + this.logicalOutputProperty.getName()));
        this.userRoleProperty = owlModel.getOWLObjectProperty(String.valueOf(this.upperServiceOntologyPrefix) + "userRole");
        if (this.userRoleProperty == null) {
            throw new IllegalArgumentException("userRoleProperty not present.");
        }
        log.trace((Object)("Found userRoleProperty: " + this.userRoleProperty.getName()));
        this.textDescriptionProperty = owlModel.getOWLDatatypeProperty(String.valueOf(this.upperServiceOntologyPrefix) + "textDescription");
        if (this.textDescriptionProperty == null) {
            throw new IllegalArgumentException("textDescriptionProperty not present.");
        }
        log.trace((Object)("Found textDescriptionProperty: " + this.textDescriptionProperty.getName()));
        this.serviceProfileClass = owlModel.getOWLNamedClass(String.valueOf(this.upperServiceOntologyPrefix) + "ServiceProfile");
        if (this.serviceProfileClass == null) {
            throw new IllegalArgumentException("serviceProfileClass not present.");
        }
        log.trace((Object)("Found serviceProfileClass: " + this.serviceProfileClass.getName()));
    }

    private ProfileIndividualInfo gatherProfileInfo(OWLIndividual profile) {
        ProfileIndividualInfo piInfo = new ProfileIndividualInfo();
        piInfo.setProfile(profile);
        piInfo.setDescription(profile.getPropertyValueLiteral((RDFProperty)this.textDescriptionProperty));
        HashSet<Object> set = new HashSet<OWLIndividual>();
        set.addAll(profile.getPropertyValues((RDFProperty)this.preconditionProperty));
        piInfo.setPreconditions(set);
        set = new HashSet();
        set.addAll(profile.getPropertyValues((RDFProperty)this.effectProperty));
        piInfo.setEffects(set);
        set = new HashSet();
        set.addAll(profile.getPropertyValues((RDFProperty)this.logicalInputProperty));
        piInfo.setLogicalInputs(set);
        set = new HashSet();
        set.addAll(profile.getPropertyValues((RDFProperty)this.logicalOutputProperty));
        piInfo.setLogicalOutputs(set);
        set = new HashSet();
        set.addAll(profile.getPropertyValues((RDFProperty)this.userRoleProperty));
        piInfo.setUserRoles(set);
        return piInfo;
    }

    @Override
    public int getAvailableSearchLevels() {
        return 7;
    }

    @Override
    public List<ProfileIndividualInfo> findProfileIndividuals(int searchLevel) throws IOException {
        if (searchLevel >= this.getAvailableSearchLevels()) {
            throw new IllegalArgumentException("SearchLevel " + searchLevel + " not supported.");
        }
        if (this.piParameter == null) {
            throw new IllegalStateException("The search parameter must be set prior to a call to findProfileIndividuals");
        }
        if (searchLevel != this.expectedSearchLevel) {
            throw new IllegalStateException("Wrong search level: Given " + searchLevel + " Expected " + this.expectedSearchLevel);
        }
        this.expectedSearchLevel = (this.expectedSearchLevel + 1) % this.getAvailableSearchLevels();
        LinkedList<ProfileIndividualInfo> results = new LinkedList<ProfileIndividualInfo>();
        ProfileIndividualParameter mySearchParameter = this.piParameter.clone();
        if (mySearchParameter.getCategory() == null) {
            mySearchParameter.setCategory(this.serviceProfileClass);
        }
        try {
            switch (searchLevel) {
                case 0: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    this.requiredClasses = mySearchParameter.clone();
                    this.createIndividualsQuery(mySearchParameter, askDoc, false, false, false, false, false, false, true);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.removeExcessiveMatches(results, false, false, false, false, false, false, true);
                    break;
                }
                case 1: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, false, false, true);
                    this.createAncestorQueries(mySearchParameter.getPreconditions(), askDoc);
                    this.createDescendantQueries(mySearchParameter.getEffects(), askDoc);
                    this.createDescendantQueries(mySearchParameter.getUserRoles(), askDoc);
                    if (this.piParameter.getCategory() != null) {
                        this.createDescendantQueries((Collection<OWLClass>)Collections.singletonList(mySearchParameter.getCategory()), askDoc);
                    }
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.fillAncestors(mySearchParameter.getPreconditions(), this.conformClasses.getPreconditions());
                    this.fillDescendants(mySearchParameter.getEffects(), this.conformClasses.getEffects());
                    this.fillDescendants(mySearchParameter.getUserRoles(), this.conformClasses.getUserRoles());
                    if (this.piParameter.getCategory() != null) {
                        this.fillDescendants((Collection<OWLClass>)Collections.singletonList(mySearchParameter.getCategory()), this.conformClasses.getCategories());
                    }
                    this.removeExcessiveMatches(results, true, true, true, true, false, false, true);
                    break;
                }
                case 2: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, true, true, true);
                    this.createAncestorQueries(mySearchParameter.getLogicalInputs(), askDoc);
                    this.createDescendantQueries(mySearchParameter.getLogicalOutputs(), askDoc);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.fillAncestors(mySearchParameter.getLogicalInputs(), this.conformClasses.getLogicalInputs());
                    this.fillDescendants(mySearchParameter.getLogicalOutputs(), this.conformClasses.getLogicalOutputs());
                    this.removeExcessiveMatches(results, true, true, true, true, true, true, true);
                    break;
                }
                case 3: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, true, true, false);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.removeExcessiveMatches(results, true, true, true, true, true, true, false);
                    break;
                }
                case 4: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    mySearchParameter.getUserRoles().clear();
                    this.requiredClasses = mySearchParameter.clone();
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, true, true, false);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.removeExcessiveMatches(results, true, true, true, true, true, true, false);
                    break;
                }
                case 5: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    mySearchParameter.getUserRoles().clear();
                    mySearchParameter.setCategory(this.serviceProfileClass);
                    this.requiredClasses = mySearchParameter.clone();
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, true, true, false);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.removeExcessiveMatches(results, true, true, true, true, true, true, false);
                    break;
                }
                case 6: {
                    Document askDoc = this.digTranslator.createAsksDocument(this.owlReasoner.getReasonerKnowledgeBaseURI());
                    mySearchParameter.setCategory(this.serviceProfileClass);
                    mySearchParameter.getUserRoles().clear();
                    mySearchParameter.getPreconditions().clear();
                    mySearchParameter.getEffects().clear();
                    this.requiredClasses = mySearchParameter.clone();
                    this.createIndividualsQuery(mySearchParameter, askDoc, true, true, true, true, true, true, false);
                    Document resultDoc = this.performRequest(askDoc);
                    this.gatherResults(resultDoc, results);
                    this.removeExcessiveMatches(results, true, true, true, true, true, true, false);
                }
            }
        }
        catch (DIGReasonerException e) {
            IOException ioe = new IOException("Problem during communication with DIG Reasoner.");
            ioe.initCause(e);
            throw ioe;
        }
        log.info((Object)("Profiles found in level " + searchLevel + ": " + results.size()));
        return results;
    }

    private void fillDescendants(Collection<OWLClass> classes, Set<OWLClass> classesDescendants) {
        for (OWLClass owlClass : classes) {
            classesDescendants.addAll(this.descendants.get(owlClass));
        }
    }

    private void fillAncestors(Collection<OWLClass> classes, Set<OWLClass> classesAncestors) {
        for (OWLClass owlClass : classes) {
            classesAncestors.addAll(this.ancestors.get(owlClass));
        }
    }

    private void gatherResults(Document resultDoc, Collection<ProfileIndividualInfo> results) throws DIGReasonerException {
        Iterator iter = this.digTranslator.getDIGQueryResponseIterator(this.owlModel, resultDoc);
        while (iter.hasNext()) {
            OWLNamedClass owlClass;
            String className;
            DIGQueryResponse response = (DIGQueryResponse)iter.next();
            String responseId = response.getID();
            if (PROFILES_QUERY_ID.equals(responseId)) {
                for (OWLIndividual profile : response.getIndividuals()) {
                    results.add(this.gatherProfileInfo(profile));
                }
                continue;
            }
            if (responseId.startsWith("ancestors:")) {
                className = responseId.substring(responseId.indexOf(":") + 1);
                owlClass = this.owlModel.getOWLNamedClass(className);
                this.ancestors.put((OWLClass)owlClass, response.getConcepts());
                if (this.piParameter.getPreconditions().contains(owlClass)) {
                    this.preconditionAncestors.put((OWLClass)owlClass, response.getConcepts());
                }
                if (!this.piParameter.getLogicalInputs().contains(owlClass)) continue;
                this.logicalInputAncestors.put((OWLClass)owlClass, response.getConcepts());
                continue;
            }
            if (!responseId.startsWith("descendants:")) continue;
            className = responseId.substring(responseId.indexOf(":") + 1);
            owlClass = this.owlModel.getOWLNamedClass(className);
            this.descendants.put((OWLClass)owlClass, response.getConcepts());
        }
    }

    private Document performRequest(Document askDoc) throws DIGReasonerException {
        log.trace((Object)"Sending dig request:");
        this.logDocument(askDoc);
        Document resultDoc = this.digReasoner.performRequest(askDoc);
        log.trace((Object)"Received dig response:");
        this.logDocument(resultDoc);
        return resultDoc;
    }

    private boolean requiredClassesPresent(Collection<OWLIndividual> individuals, Collection<OWLClass> classes, boolean allRequired) {
        HashSet<OWLClass> foundClasses = new HashSet<OWLClass>();
        for (OWLIndividual individual : individuals) {
            foundClasses.add((OWLClass)individual.getRDFType());
        }
        if (allRequired) {
            return foundClasses.containsAll(classes);
        }
        for (OWLClass owlClass : classes) {
            if (!foundClasses.contains(owlClass)) continue;
            return true;
        }
        return false;
    }

    private boolean requiredClassesPresent(Collection<OWLIndividual> individuals, Collection<OWLClass> classes, Map<OWLClass, Collection<OWLClass>> superClassesMap, boolean allRequired) {
        HashSet<OWLClass> foundClasses = new HashSet<OWLClass>();
        for (OWLIndividual individual : individuals) {
            foundClasses.add((OWLClass)individual.getRDFType());
        }
        boolean allPresent = true;
        for (OWLClass owlClass : classes) {
            boolean setMemberPresent = foundClasses.contains(owlClass);
            if (!setMemberPresent && superClassesMap.containsKey(owlClass)) {
                for (OWLClass superClass : superClassesMap.get(owlClass)) {
                    if (!foundClasses.contains(superClass)) continue;
                    setMemberPresent = true;
                    break;
                }
            }
            boolean bl = allPresent = allPresent && setMemberPresent;
            if (setMemberPresent && !allRequired) {
                return true;
            }
            if (allPresent || !allRequired) continue;
            return false;
        }
        return allPresent;
    }

    private void removeExcessiveMatches(Collection<ProfileIndividualInfo> piInfos, boolean conformCategory, boolean conformUserRoles, boolean conformPreconditions, boolean conformEffects, boolean conformInputs, boolean conformOutputs, boolean allRequired) {
        Iterator<ProfileIndividualInfo> iter = piInfos.iterator();
        while (iter.hasNext()) {
            ProfileIndividualInfo piInfo = iter.next();
            if (!conformCategory && this.requiredClasses.getCategory() != null && !this.requiredClasses.getCategory().equals(piInfo.getProfile().getRDFType())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong category"));
                }
                iter.remove();
                continue;
            }
            if (!conformUserRoles && !this.requiredClassesPresent(piInfo.getUserRoles(), this.requiredClasses.getUserRoles(), allRequired)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong userRoles"));
                }
                iter.remove();
                continue;
            }
            if (!this.requiredClassesPresent(piInfo.getLogicalInputs(), this.requiredClasses.getLogicalInputs(), this.logicalInputAncestors, allRequired)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong logicalInputs"));
                }
                iter.remove();
                continue;
            }
            if (!conformOutputs && !this.requiredClassesPresent(piInfo.getLogicalOutputs(), this.requiredClasses.getLogicalOutputs(), allRequired)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong logicalOutputs"));
                }
                iter.remove();
                continue;
            }
            if (!this.requiredClassesPresent(piInfo.getPreconditions(), this.requiredClasses.getPreconditions(), this.preconditionAncestors, allRequired)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong preconditions"));
                }
                iter.remove();
                continue;
            }
            if (conformEffects || this.requiredClassesPresent(piInfo.getEffects(), this.requiredClasses.getEffects(), allRequired)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing " + piInfo.getProfile().getName() + ": Wrong effects"));
            }
            iter.remove();
        }
    }

    private void createAncestorQueries(Collection<OWLClass> classes, Document askDoc) throws DIGReasonerException {
        for (OWLClass owlClass : classes) {
            if (this.ancestors.containsKey(owlClass)) continue;
            Element ancElement = this.digTranslator.createQueryElement(askDoc, "ancestors", "ancestors:" + owlClass.getName());
            askDoc.getDocumentElement().appendChild(ancElement);
            this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)ancElement);
        }
    }

    private void createDescendantQueries(Collection<OWLClass> classes, Document askDoc) throws DIGReasonerException {
        for (OWLClass owlClass : classes) {
            if (this.descendants.containsKey(owlClass)) continue;
            Element ancElement = this.digTranslator.createQueryElement(askDoc, "descendants", "descendants:" + owlClass.getName());
            askDoc.getDocumentElement().appendChild(ancElement);
            this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)ancElement);
        }
    }

    private Element createIndividualsQuery(ProfileIndividualParameter searchParameter, Document askDoc, boolean conformCategory, boolean conformUserRoles, boolean conformPreconditions, boolean conformEffects, boolean conformInputs, boolean conformOutputs, boolean allRequired) throws DIGReasonerException {
        Element orElement;
        Element someElement;
        Element indElement = this.digTranslator.createQueryElement(askDoc, "instances", PROFILES_QUERY_ID);
        askDoc.getDocumentElement().appendChild(indElement);
        Element andElement = askDoc.createElement("and");
        indElement.appendChild(andElement);
        Element toAppend = andElement;
        this.digTranslator.translateToDIG((RDFResource)searchParameter.getCategory(), askDoc, (Node)toAppend);
        if (!conformPreconditions) {
            for (OWLClass owlClass : searchParameter.getPreconditions()) {
                someElement = askDoc.createElement("some");
                toAppend.appendChild(someElement);
                this.digTranslator.translateToDIG((RDFResource)this.preconditionProperty, askDoc, (Node)someElement);
                this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)someElement);
            }
        }
        if (!searchParameter.getEffects().isEmpty() && !allRequired) {
            orElement = askDoc.createElement("or");
            toAppend.appendChild(orElement);
            toAppend = orElement;
        }
        for (OWLClass owlClass : searchParameter.getEffects()) {
            someElement = askDoc.createElement("some");
            toAppend.appendChild(someElement);
            this.digTranslator.translateToDIG((RDFResource)this.effectProperty, askDoc, (Node)someElement);
            this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)someElement);
        }
        toAppend = andElement;
        if (!conformInputs) {
            for (OWLClass owlClass : searchParameter.getLogicalInputs()) {
                someElement = askDoc.createElement("some");
                toAppend.appendChild(someElement);
                this.digTranslator.translateToDIG((RDFResource)this.logicalInputProperty, askDoc, (Node)someElement);
                this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)someElement);
            }
        }
        if (!searchParameter.getLogicalOutputs().isEmpty() && !allRequired) {
            orElement = askDoc.createElement("or");
            toAppend.appendChild(orElement);
            toAppend = orElement;
        }
        for (OWLClass owlClass : searchParameter.getLogicalOutputs()) {
            someElement = askDoc.createElement("some");
            toAppend.appendChild(someElement);
            this.digTranslator.translateToDIG((RDFResource)this.logicalOutputProperty, askDoc, (Node)someElement);
            this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)someElement);
        }
        toAppend = andElement;
        if (!searchParameter.getUserRoles().isEmpty() && !allRequired) {
            orElement = askDoc.createElement("or");
            toAppend.appendChild(orElement);
            toAppend = orElement;
        }
        for (OWLClass owlClass : searchParameter.getUserRoles()) {
            someElement = askDoc.createElement("some");
            toAppend.appendChild(someElement);
            this.digTranslator.translateToDIG((RDFResource)this.userRoleProperty, askDoc, (Node)someElement);
            this.digTranslator.translateToDIG((RDFResource)owlClass, askDoc, (Node)someElement);
        }
        return indElement;
    }

    private void logDocument(Document doc) {
        if (log.isTraceEnabled()) {
            try {
                OutputFormat format = new OutputFormat();
                format.setIndent(4);
                format.setIndenting(true);
                format.setPreserveSpace(false);
                XMLSerializer serializer = new XMLSerializer(format);
                StringWriter writer = new StringWriter();
                serializer.setOutputCharStream((Writer)writer);
                serializer.serialize(doc);
                writer.close();
                log.trace((Object)writer.getBuffer());
            }
            catch (IOException e) {
                log.warn((Object)"Error while creating log output.", (Throwable)e);
            }
        }
    }

    @Override
    public void setProfileIndividualParameter(ProfileIndividualParameter searchParameter) {
        this.piParameter = searchParameter;
        this.expectedSearchLevel = 0;
        this.conformClasses = new ParameterConformClasses();
    }

    @Override
    public ParameterConformClasses getConformClasses() {
        return this.conformClasses;
    }
}

