/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractOWLCardinalityBase
extends AbstractOWLRestriction
implements OWLCardinalityBase {
    private final char operatorChar;

    public AbstractOWLCardinalityBase(KnowledgeBase kb, FrameID id, char operatorChar) {
        super(kb, id);
        this.operatorChar = operatorChar;
    }

    AbstractOWLCardinalityBase(char operatorChar) {
        this.operatorChar = operatorChar;
    }

    public void checkFillerText(String text) throws Exception {
        AbstractOWLCardinalityBase.checkFillerText(text, this.getOnProperty());
    }

    public static void checkFillerText(String text, RDFProperty property) throws OWLClassParseException, NumberFormatException {
        int i;
        int spaceIndex;
        text = text.trim();
        if (ProfilesManager.isFeatureSupported(property.getOWLModel(), OWLProfiles.Qualified_Cardinality_Restrictions) && (spaceIndex = text.indexOf(32)) > 0) {
            String qualifierString = text.substring(spaceIndex + 1);
            OWLClassParser parser = property.getOWLModel().getOWLClassDisplay().getParser();
            parser.checkClass(property.getOWLModel(), qualifierString);
            text = text.substring(0, spaceIndex);
        }
        if ((i = Integer.valueOf(text).intValue()) < 0) {
            throw new NumberFormatException("Negative cardinality: " + i);
        }
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof AbstractOWLCardinalityBase) {
            AbstractOWLCardinalityBase base = (AbstractOWLCardinalityBase)object;
            return this.getOperator() == base.getOperator() && this.getCardinality() == base.getCardinality() && this.getOnProperty().equalsStructurally(base.getOnProperty()) && this.getQualifier().equalsStructurally(base.getQualifier());
        }
        return false;
    }

    public int getCardinality() {
        Object value = this.getPropertyValue(this.getFillerProperty());
        if (value instanceof RDFSLiteral) {
            return ((RDFSLiteral)value).getInt();
        }
        Integer i = (Integer)value;
        return i == null ? 0 : i;
    }

    public RDFSClass getQualifier() {
        RDFSClass valuesFrom = this.getValuesFrom();
        if (valuesFrom == null) {
            return this.getOWLModel().getOWLThingClass();
        }
        return valuesFrom;
    }

    public RDFSClass getValuesFrom() {
        return (RDFSClass)this.getPropertyValue(this.getOWLModel().getOWLValuesFromProperty());
    }

    public String getFillerText() {
        if (this.isQualified()) {
            return String.valueOf(Integer.toString(this.getCardinality())) + " " + this.getValuesFrom().getNestedBrowserText();
        }
        return Integer.toString(this.getCardinality());
    }

    public void getNestedNamedClasses(Set set) {
    }

    public boolean isQualified() {
        return this.getValuesFrom() != null;
    }

    public void setCardinality(int value) {
        this.setDirectOwnSlotValue(this.getFillerProperty(), new Integer(value));
    }

    public void setFillerText(String text) throws Exception {
        if (text.length() > 0) {
            Integer value;
            int spaceIndex = text.indexOf(32);
            if (spaceIndex > 0) {
                String qualifierString = text.substring(spaceIndex + 1);
                OWLClassParser parser = this.getOWLModel().getOWLClassDisplay().getParser();
                RDFSClass qualifier = parser.parseClass(this.getOWLModel(), qualifierString);
                this.setValuesFrom(qualifier);
                text = text.substring(0, spaceIndex);
            }
            if ((value = Integer.valueOf(text)) >= 0) {
                this.setCardinality(value);
            }
        } else {
            this.setDirectOwnSlotValue(this.getFillerProperty(), null);
        }
    }

    public void setValuesFrom(RDFSClass value) {
        this.setPropertyValue(this.getOWLModel().getOWLValuesFromProperty(), value);
    }

    public Collection getDependingClasses() {
        RDFSClass qualifier;
        if (this.isQualified() && (qualifier = this.getQualifier()).isAnonymous()) {
            return Collections.singleton(qualifier);
        }
        return Collections.EMPTY_LIST;
    }
}

