/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.Rational;
import com.hp.hpl.jena.graph.test.RationalType;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;

public class TestTypedLiterals
extends TestCase {
    private Model m = ModelFactory.createDefaultModel();

    public TestTypedLiterals(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTypedLiterals.class);
    }

    public void testUnknown() {
        boolean bl;
        String string = "urn:x-hp-dt:unknown";
        String string2 = "urn:x-hp-dt:unknown2";
        boolean bl2 = JenaParameters.enableSilentAcceptanceOfUnknownDatatypes;
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = true;
        Literal literal = this.m.createTypedLiteral("foo", string);
        Literal literal2 = this.m.createTypedLiteral("15", string);
        Literal literal3 = this.m.createTypedLiteral("foo", string2);
        Literal literal4 = this.m.createLiteral("foo", "lang1");
        Literal literal5 = this.m.createLiteral("foo");
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = bl2;
        TestTypedLiterals.assertNotNull((Object)literal);
        TestTypedLiterals.assertNotNull((Object)literal2);
        TestTypedLiterals.assertNotNull((Object)literal3);
        this.assertDiffer("datatype sensitive", literal, literal3);
        this.assertDiffer("value sensitive", literal, literal2);
        this.assertDiffer("typed and plain differ", literal, literal4);
        try {
            int bl3 = literal2.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract value", (Object)literal.getValue(), (Object)"foo");
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = false;
        boolean bl4 = false;
        try {
            Literal literal6 = this.m.createTypedLiteral("food", string + "3");
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl = true;
        }
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = bl2;
        TestTypedLiterals.assertTrue((String)"Detected unknown datatype", (boolean)bl);
    }

    public void testUserDef() {
        RDFDatatype rDFDatatype = RationalType.theRationalType;
        TypeMapper.getInstance().registerDatatype(rDFDatatype);
        Literal literal = this.m.createTypedLiteral("3/5", rDFDatatype);
        Literal literal2 = this.m.createTypedLiteral("7/5", rDFDatatype);
        TestTypedLiterals.assertNotNull((Object)literal);
        TestTypedLiterals.assertNotNull((Object)literal2);
        this.assertDiffer("values should be tested!", literal, literal2);
        TestTypedLiterals.assertSame((String)"Datatype incorrect", (Object)literal.getDatatype(), (Object)rDFDatatype);
        TestTypedLiterals.assertEquals((String)"Datatype uri incorrect", (String)literal.getDatatypeURI(), (String)"urn:x-hp-dt:rational");
        Object object = literal.getValue();
        TestTypedLiterals.assertTrue((String)"Value space check", (boolean)(object instanceof Rational));
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)object).getNumerator() == 3 ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)object).getDenominator() == 5 ? 1 : 0) != 0);
        try {
            int n = literal.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
    }

    public void testXMLLiteral() {
        Literal literal = this.m.createLiteral("<bad", true);
        TestTypedLiterals.assertTrue((String)"Error checking must be off.", (boolean)((EnhNode)((Object)literal)).asNode().getLiteral().isXML());
        literal = this.m.createTypedLiteral("<bad/>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertFalse((String)"Error checking must be on.", (boolean)((EnhNode)((Object)literal)).asNode().getLiteral().isXML());
        literal = this.m.createTypedLiteral("<good></good>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertTrue((String)"Well-formed XMLLiteral.", (boolean)((EnhNode)((Object)literal)).asNode().getLiteral().isXML());
    }

    public void testXSDbasics() {
        String string = "http://www.w3.org/2001/XMLSchema#int";
        Literal literal = this.m.createTypedLiteral(42);
        Literal literal2 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDint);
        Literal literal3 = this.m.createTypedLiteral("63");
        this.assertSameValueAs("Default map failed", literal, literal2);
        TestTypedLiterals.assertEquals((String)"Value wrong", (Object)literal.getValue(), (Object)new Integer(42));
        TestTypedLiterals.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)Integer.class);
        TestTypedLiterals.assertEquals((String)"Value accessor problem", (int)literal.getInt(), (int)42);
        TestTypedLiterals.assertEquals((String)"wrong type name", (String)literal2.getDatatypeURI(), (String)string);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDint);
        this.assertDiffer("Not value sensitive", literal, literal3);
        this.checkIllegalLiteral("zap", XSDDatatype.XSDint);
        this.checkIllegalLiteral("42.1", XSDDatatype.XSDint);
        Literal literal4 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("type coercion", literal2, literal4);
        literal = this.m.createTypedLiteral(42.42);
        literal2 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal literal5 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDdouble);
        TestTypedLiterals.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)Double.class);
        this.assertFloatEquals("value wrong", ((Double)literal.getValue()).floatValue(), 42.42);
        TestTypedLiterals.assertEquals((String)"class wrong", literal2.getValue().getClass(), (Object)Float.class);
        this.assertFloatEquals("value wrong", ((Float)literal2.getValue()).floatValue(), 42.42);
        this.assertFloatEquals("Value accessor problem", literal.getFloat(), 42.42);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDfloat);
        this.assertSameValueAs("equality fn", literal, literal5);
        this.checkLegalLiteral("12345", XSDDatatype.XSDlong, Long.class, new Long(12345L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDlong, Long.class, new Long(-12345L));
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDlong);
        this.checkLegalLiteral("1234", XSDDatatype.XSDshort, Short.class, new Short(1234));
        this.checkLegalLiteral("-1234", XSDDatatype.XSDshort, Short.class, new Short(-1234));
        this.checkLegalLiteral("32767", XSDDatatype.XSDshort, Short.class, new Short(Short.MAX_VALUE));
        this.checkLegalLiteral("-32768", XSDDatatype.XSDshort, Short.class, new Short(Short.MIN_VALUE));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDshort);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDshort);
        this.checkLegalLiteral("42", XSDDatatype.XSDbyte, Byte.class, new Byte(42));
        this.checkLegalLiteral("-42", XSDDatatype.XSDbyte, Byte.class, new Byte(-42));
        this.checkLegalLiteral("127", XSDDatatype.XSDbyte, Byte.class, new Byte(127));
        this.checkLegalLiteral("-128", XSDDatatype.XSDbyte, Byte.class, new Byte(-128));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("128", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDbyte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedLong, Long.class, new Long(12345L));
        this.checkLegalLiteral("+12345", XSDDatatype.XSDunsignedLong, Long.class, new Long(12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDunsignedLong, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedLong);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedInt, Long.class, new Long(12345L));
        this.checkLegalLiteral("2147483648", XSDDatatype.XSDunsignedInt, Long.class, new Long(0x80000000L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedInt);
        this.checkLegalLiteral("1234", XSDDatatype.XSDunsignedShort, Integer.class, new Integer(1234));
        this.checkLegalLiteral("32679", XSDDatatype.XSDunsignedShort, Integer.class, new Integer(32679));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedShort);
        this.checkLegalLiteral("123", XSDDatatype.XSDunsignedByte, Short.class, new Short(123));
        this.checkLegalLiteral("129", XSDDatatype.XSDunsignedByte, Short.class, new Short(129));
        this.checkIllegalLiteral("-123", XSDDatatype.XSDunsignedByte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDinteger, Long.class, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDinteger, Long.class, new Long(0L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDinteger, Long.class, new Long(-12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDinteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDpositiveInteger, Long.class, new Long(12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDpositiveInteger);
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDpositiveInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDpositiveInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDnonNegativeInteger, Long.class, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonNegativeInteger, Long.class, new Long(0L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDnonNegativeInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDnonNegativeInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnegativeInteger, Long.class, new Long(-12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDnegativeInteger);
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnegativeInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnegativeInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnonPositiveInteger, Long.class, new Long(-12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonPositiveInteger, Long.class, new Long(0L));
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnonPositiveInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnonPositiveInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDdecimal, Long.class, new Long("12345"));
        this.checkLegalLiteral("0.0", XSDDatatype.XSDdecimal, Long.class, new Long("0"));
        this.checkLegalLiteral("42.45", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("42.45"));
        this.checkLegalLiteral("9223372036854775808.1234", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("9223372036854775808.1234"));
        this.checkLegalLiteral("123.4", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("123.4"));
        this.checkIllegalLiteral("123,4", XSDDatatype.XSDdecimal);
        this.checkLegalLiteral("true", XSDDatatype.XSDboolean, Boolean.class, new Boolean(true));
        this.checkLegalLiteral("false", XSDDatatype.XSDboolean, Boolean.class, new Boolean(false));
        literal = this.m.createTypedLiteral(true);
        TestTypedLiterals.assertEquals((String)"boolean mapping", (Object)XSDDatatype.XSDboolean, (Object)literal.getDatatype());
        this.checkLegalLiteral("hello world", XSDDatatype.XSDstring, String.class, "hello world");
        literal = this.m.createTypedLiteral("foo bar");
        TestTypedLiterals.assertEquals((String)"string mapping", (Object)XSDDatatype.XSDstring, (Object)literal.getDatatype());
    }

    public void testMiscEquality() {
        Literal literal = this.m.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = this.m.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("Int lex form", literal, literal2);
        literal = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDint);
        literal2 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("numeric comparisons", literal, literal2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverloads() {
        boolean bl = JenaParameters.enableEagerLiteralValidation;
        try {
            Literal literal;
            Object object;
            JenaParameters.enableEagerLiteralValidation = true;
            boolean bl2 = false;
            try {
                Literal literal2 = this.m.createTypedLiteral("foo", "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException datatypeFormatException) {
                bl2 = true;
            }
            TestTypedLiterals.assertTrue((String)"detected illegal string, direct", (boolean)bl2);
            boolean bl3 = false;
            try {
                object = "foo";
                literal = this.m.createTypedLiteral(object, "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException datatypeFormatException) {
                bl3 = true;
            }
            TestTypedLiterals.assertTrue((String)"detected illegal string, overloaded", (boolean)bl3);
            object = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            ((Calendar)object).set(1999, 4, 30, 15, 9, 32);
            ((Calendar)object).set(14, 0);
            literal = this.m.createTypedLiteral(object);
            TestTypedLiterals.assertEquals((String)"calendar overloading test", (Object)this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), (Object)literal);
        }
        finally {
            JenaParameters.enableEagerLiteralValidation = bl;
        }
    }

    public void testPlainSameValueAs() {
        Literal literal = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDstring);
        Literal literal2 = this.m.createTypedLiteral("10", (RDFDatatype)null);
        Literal literal3 = this.m.createTypedLiteral("10", (String)null);
        Literal literal4 = this.m.createLiteral("10");
        Literal literal5 = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("Null type = plain literal", literal2, literal4);
        this.assertSameValueAs("Null type = plain literal", literal2, literal3);
        this.assertSameValueAs("Null type = plain literal", literal4, literal3);
        TestTypedLiterals.assertTrue((String)"null type", (literal3.getDatatype() == null ? 1 : 0) != 0);
        this.assertDiffer("String != int", literal, literal5);
        this.assertDiffer("Plain != int", literal2, literal5);
        this.assertDiffer("Plain != int", literal4, literal5);
        if (JenaParameters.enablePlainLiteralSameAsString) {
            this.assertSameValueAs("String != plain??", literal, literal2);
            this.assertSameValueAs("String != plain??", literal, literal4);
        } else {
            this.assertDiffer("String != plain??", literal, literal2);
            this.assertDiffer("String != plain??", literal, literal4);
        }
    }

    public void testUserDefined() throws IOException {
        String string = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String string2 = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper typeMapper = TypeMapper.getInstance();
        List list = XSDDatatype.loadUserDefined(string, new FileReader(string2), null, typeMapper);
        this.assertIteratorValues(list.iterator(), new Object[]{string + "#XSDEnumerationHeight", string + "#over12", string + "#over17", string + "#over59", string + "#clothingsize"});
        RDFDatatype rDFDatatype = typeMapper.getSafeTypeByName(string + "#XSDEnumerationHeight");
        this.checkLegalLiteral("short", rDFDatatype, String.class, "short");
        this.checkLegalLiteral("tall", rDFDatatype, String.class, "tall");
        this.checkIllegalLiteral("shortish", rDFDatatype);
        RDFDatatype rDFDatatype2 = typeMapper.getSafeTypeByName(string + "#over12");
        this.checkLegalLiteral("15", rDFDatatype2, Long.class, new Long(15L));
        this.checkIllegalLiteral("12", rDFDatatype2);
        RDFDatatype rDFDatatype3 = typeMapper.getSafeTypeByName(string + "#clothingsize");
        this.checkLegalLiteral("42", rDFDatatype3, Long.class, new Long(42L));
        this.checkLegalLiteral("short", rDFDatatype3, String.class, "short");
        LiteralLabel literalLabel = this.m.createTypedLiteral("13", rDFDatatype2).asNode().getLiteral();
        LiteralLabel literalLabel2 = this.m.createTypedLiteral("14", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel literalLabel3 = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel literalLabel4 = this.m.createTypedLiteral("15", (RDFDatatype)XSDDatatype.XSDstring).asNode().getLiteral();
        LiteralLabel literalLabel5 = this.m.createLiteral("foo").asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)rDFDatatype2.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)rDFDatatype2.isValidLiteral(literalLabel2));
        TestTypedLiterals.assertTrue((!rDFDatatype2.isValidLiteral(literalLabel3) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!rDFDatatype2.isValidLiteral(literalLabel4) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!rDFDatatype2.isValidLiteral(literalLabel5) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel2));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel3));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(literalLabel4) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(literalLabel5) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel4));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel5));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel3) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel2) ? 1 : 0) != 0);
    }

    public void testDateTime() {
        Literal literal = this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals((String)"duration data type", (Object)XSDDatatype.XSDduration, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"duration java type", (Object)XSDDuration.class, literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"duration value", (int)1, (int)((XSDDuration)literal.getValue()).getYears());
        TestTypedLiterals.assertEquals((String)"duration value", (int)2, (int)((XSDDuration)literal.getValue()).getMonths());
        TestTypedLiterals.assertEquals((String)"duration value", (int)3, (int)((XSDDuration)literal.getValue()).getDays());
        TestTypedLiterals.assertEquals((String)"duration value", (int)5, (int)((XSDDuration)literal.getValue()).getHours());
        TestTypedLiterals.assertEquals((String)"duration value", (int)6, (int)((XSDDuration)literal.getValue()).getMinutes());
        TestTypedLiterals.assertEquals((String)"duration value", (int)7, (int)((XSDDuration)literal.getValue()).getFullSeconds());
        this.assertFloatEquals("duration value", 18367.5, ((XSDDuration)literal.getValue()).getTimePart());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"P1Y2M3DT5H6M7.5S", (String)literal.getValue().toString());
        TestTypedLiterals.assertEquals((String)"equality test", (Object)literal, (Object)this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration));
        TestTypedLiterals.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("P1Y2M2DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        XSDDateTime xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)2, (int)xSDDateTime.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)9, (int)xSDDateTime.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"1999-05-31T02:09:32Z", (String)literal.getValue().toString());
        Calendar calendar = xSDDateTime.asCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(1999, 4, 31, 2, 9, 32);
        gregorianCalendar.set(14, 0);
        TestTypedLiterals.assertEquals((String)"calendar value", (Object)calendar, (Object)gregorianCalendar);
        TestTypedLiterals.assertEquals((String)"equality test", (Object)literal, (Object)this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        TestTypedLiterals.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("1999-04-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime) ? 1 : 0) != 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar2.set(1999, 4, 30, 15, 9, 32);
        gregorianCalendar2.set(14, 0);
        Literal literal2 = this.m.createTypedLiteral(gregorianCalendar2);
        TestTypedLiterals.assertEquals((String)"calendar 24 hour test", (Object)this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), (Object)literal2);
        TestTypedLiterals.assertEquals((String)"calendar value", (Object)calendar, (Object)gregorianCalendar);
        TestTypedLiterals.assertEquals((String)"equality test", (Object)literal, (Object)this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar3.clear();
        gregorianCalendar3.set(1999, 0, 30, 15, 9, 32);
        literal2 = this.m.createTypedLiteral(gregorianCalendar3);
        TestTypedLiterals.assertEquals((String)"1999-01-30T15:09:32Z", (String)literal2.getLexicalForm());
        String string = "rdf://test.com#";
        String string2 = string + "1";
        String string3 = string + "prop";
        String string4 = "<" + string2 + "> <" + string3 + "> \"" + literal2.getLexicalForm() + "\"^^<" + literal2.getDatatypeURI() + "> .";
        StringReader stringReader = new StringReader(string4);
        this.m.read(stringReader, string, "N3");
        TestTypedLiterals.assertTrue((boolean)this.m.contains(this.m.getResource(string2), this.m.getProperty(string3)));
        Resource resource = this.m.getResource(string2);
        Property property = this.m.getProperty(string3);
        XSDDateTime xSDDateTime2 = (XSDDateTime)resource.getProperty(property).getLiteral().getValue();
        TestTypedLiterals.assertEquals((String)"deserialized calendar value", (Object)gregorianCalendar3, (Object)xSDDateTime2.asCalendar());
        GregorianCalendar gregorianCalendar4 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar4.set(1999, 4, 30, 15, 9, 32);
        gregorianCalendar4.set(14, 25);
        Literal literal3 = this.m.createTypedLiteral(gregorianCalendar4);
        TestTypedLiterals.assertEquals((String)"serialization", (String)"1999-05-30T15:09:32.25Z", (String)literal3.getValue().toString());
        TestTypedLiterals.assertEquals((String)"calendar ms test", (Object)this.m.createTypedLiteral("1999-05-30T15:09:32.25Z", (RDFDatatype)XSDDatatype.XSDdateTime), (Object)literal3);
        XSDDateTime xSDDateTime3 = (XSDDateTime)literal3.getValue();
        TestTypedLiterals.assertEquals((Object)xSDDateTime3.asCalendar(), (Object)gregorianCalendar4);
        literal = this.m.createTypedLiteral("1999-05-31", (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdate, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getHours();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("12:56:32", (RDFDatatype)XSDDatatype.XSDtime);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDtime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)12, (int)xSDDateTime.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)56, (int)xSDDateTime.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        try {
            xSDDateTime.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999-05", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYearMonth, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999", (RDFDatatype)XSDDatatype.XSDgYear);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYear, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        try {
            xSDDateTime.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05--", (RDFDatatype)XSDDatatype.XSDgMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonth, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05-25", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonthDay, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("---25", (RDFDatatype)XSDDatatype.XSDgDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgDay, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar5 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar5.set(2003, 11, 8, 10, 50, 42);
        gregorianCalendar5.set(14, 0);
        literal = this.m.createTypedLiteral(gregorianCalendar5);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2003-12-08T10:50:42Z", (String)literal.getValue().toString());
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(-28800000, "America/Los_Angeles");
        simpleTimeZone.setStartRule(3, 1, 1, 0x6DDD00);
        simpleTimeZone.setEndRule(9, -1, 1, 0x6DDD00);
        gregorianCalendar5 = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar5.set(2004, 2, 21, 12, 50, 42);
        gregorianCalendar5.set(14, 0);
        literal = this.m.createTypedLiteral(gregorianCalendar5);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2004-03-21T20:50:42Z", (String)literal.getValue().toString());
        gregorianCalendar5 = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar5.set(2004, 3, 21, 12, 50, 42);
        gregorianCalendar5.set(14, 0);
        literal = this.m.createTypedLiteral(gregorianCalendar5);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2004-04-21T19:50:42Z", (String)literal.getValue().toString());
    }

    public void testTypedQueries() {
        Model model = ModelFactory.createDefaultModel();
        Property property = model.createProperty("urn:x-eg/p");
        Literal literal = model.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = model.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("sameas test", literal, literal2);
        Resource resource = model.createResource("urn:x-eg/a");
        resource.addProperty(property, literal);
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(null, property.asNode(), literal.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(null, property.asNode(), literal2.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(resource.asNode(), property.asNode(), literal2.asNode()).hasNext());
        Query query = new Query();
        query.addMatch(resource.asNode(), property.asNode(), literal2.asNode());
        ExtendedIterator extendedIterator = model.getGraph().queryHandler().prepareBindings(query, new Node[0]).executeBindings();
        TestTypedLiterals.assertTrue((boolean)extendedIterator.hasNext());
        TestTypedLiterals.assertTrue((boolean)model.listStatements(resource, property, literal2).hasNext());
    }

    public void testIsValidLiteral() {
        Literal literal = this.m.createTypedLiteral("1000", (RDFDatatype)XSDDatatype.XSDinteger);
        LiteralLabel literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDbyte.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("-2", (RDFDatatype)XSDDatatype.XSDinteger);
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDbyte.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel));
        literal = this.m.createTypedLiteral("4.5", (RDFDatatype)XSDDatatype.XSDfloat);
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdouble.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Literal literal2 = this.m.createTypedLiteral("foo", (RDFDatatype)XSDDatatype.XSDstring);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literal2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnormalizedString.isValidLiteral(literal2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literal2.asNode().getLiteral()) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("foo bar");
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("12");
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue(new Long(10L)));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue(new Integer(10)));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue(new Long(-10L)) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue("10") ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDfloat.isValidValue(new Float("2.3")));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdouble.isValidValue(new Double("2.3")));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDfloat.isValidValue(new Integer("2")) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDfloat.isValidValue(new Double("2.3")) ? 1 : 0) != 0);
    }

    public void testBinary() {
        byte[] byArray = new byte[]{12, 42, 99};
        Literal literal = this.m.createTypedLiteral(byArray);
        LiteralLabel literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertEquals((String)"binary test 1", (Object)literalLabel.getDatatype(), (Object)XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertEquals((String)"binary test 2", (String)Base64.encode((byte[])byArray), (String)literalLabel.getLexicalForm());
        LiteralLabel literalLabel2 = this.m.createTypedLiteral(literalLabel.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        Object object = literalLabel2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3", (boolean)(object instanceof byte[]));
        byte[] byArray2 = (byte[])object;
        TestTypedLiterals.assertEquals((String)"binary test 4", (int)byArray2[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5", (int)byArray2[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6", (int)byArray2[2], (int)99);
        TestTypedLiterals.assertEquals((Object)literalLabel2, (Object)literalLabel);
        literalLabel2 = this.m.createTypedLiteral("DCpj", (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        object = literalLabel2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3", (boolean)(object instanceof byte[]));
        byArray2 = (byte[])object;
        TestTypedLiterals.assertEquals((String)"binary test 4", (int)byArray2[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5", (int)byArray2[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6", (int)byArray2[2], (int)99);
        literal = this.m.createTypedLiteral((Object)byArray, (RDFDatatype)XSDDatatype.XSDhexBinary);
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertEquals((String)"binary test 1b", (Object)literalLabel.getDatatype(), (Object)XSDDatatype.XSDhexBinary);
        TestTypedLiterals.assertEquals((String)"binary test 2b", (String)HexBin.encode((byte[])byArray), (String)literalLabel.getLexicalForm());
        literalLabel2 = this.m.createTypedLiteral(literalLabel.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDhexBinary).asNode().getLiteral();
        object = literalLabel2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3b", (boolean)(object instanceof byte[]));
        byArray2 = (byte[])object;
        TestTypedLiterals.assertEquals((String)"binary test 4b", (int)byArray2[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5b", (int)byArray2[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6b", (int)byArray2[2], (int)99);
        TestTypedLiterals.assertEquals((Object)literalLabel2, (Object)literalLabel);
        Literal literal2 = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        Literal literal3 = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertTrue((String)"equality test", (boolean)literal2.sameValueAs(literal3));
    }

    public void XXtestBinaryBug() throws IOException {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hpl.hp.com/test#r");
        Property property = model.createProperty("http://jena.hpl.hp.com/test#p");
        Literal literal = model.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        model.add(resource, property, literal);
        for (int i = 0; i < 150; ++i) {
            literal = model.createTypedLiteral(new byte[]{(byte)i, (byte)i, (byte)i});
            model.add(model.createResource("urn:x-hp:" + i), property, literal);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        model.write(byteArrayOutputStream, "RDF/XML-ABBREV");
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(byteArrayInputStream, null);
        ((InputStream)byteArrayInputStream).close();
        TestTypedLiterals.assertTrue((boolean)model.isIsomorphicWith(model2));
    }

    public void testDateTimeBug() {
        String string = XSD.date.getURI();
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getSafeTypeByName(string);
        Object object = rDFDatatype.parse("2003-05-21");
        Literal literal = this.m.createTypedLiteral(object, rDFDatatype);
        String string2 = literal.toString();
        Object object2 = rDFDatatype.parse(object.toString());
        TestTypedLiterals.assertEquals((Object)object, (Object)object2);
        XSDDatatype xSDDatatype = XSDDatatype.XSDdate;
        Literal literal2 = this.m.createTypedLiteral("2003-05-21", (RDFDatatype)xSDDatatype);
        this.checkSerialization("2003-05-21", XSDDatatype.XSDdate);
        this.checkSerialization("2003-05-21T12:56:10Z", XSDDatatype.XSDdateTime);
        this.checkSerialization("2003-05", XSDDatatype.XSDgYearMonth);
        this.checkSerialization("2003", XSDDatatype.XSDgYear);
        this.checkSerialization("--05", XSDDatatype.XSDgMonth);
        this.checkSerialization("--05-12", XSDDatatype.XSDgMonthDay);
        this.checkSerialization("---12", XSDDatatype.XSDgDay);
    }

    public void testFlags() {
        Literal literal;
        boolean bl = JenaParameters.enableEagerLiteralValidation;
        JenaParameters.enableEagerLiteralValidation = true;
        boolean bl2 = false;
        try {
            literal = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl2 = true;
        }
        JenaParameters.enableEagerLiteralValidation = bl;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)bl2);
        JenaParameters.enableEagerLiteralValidation = false;
        bl2 = false;
        literal = null;
        try {
            literal = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            JenaParameters.enableEagerLiteralValidation = bl;
            TestTypedLiterals.assertTrue((String)"Delayed datatype format validation", (boolean)false);
        }
        try {
            literal.getValue();
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl2 = true;
        }
        JenaParameters.enableEagerLiteralValidation = bl;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)bl2);
        bl = JenaParameters.enablePlainLiteralSameAsString;
        Literal literal2 = this.m.createLiteral("test string");
        Literal literal3 = this.m.createTypedLiteral("test string", (RDFDatatype)XSDDatatype.XSDstring);
        JenaParameters.enablePlainLiteralSameAsString = true;
        boolean bl3 = literal2.sameValueAs(literal3);
        JenaParameters.enablePlainLiteralSameAsString = false;
        boolean bl4 = !literal2.sameValueAs(literal3);
        JenaParameters.enablePlainLiteralSameAsString = bl;
        TestTypedLiterals.assertTrue((boolean)bl3);
        TestTypedLiterals.assertTrue((boolean)bl4);
    }

    public void testLexicalDistinction() {
        Literal literal = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal literal2 = this.m.createTypedLiteral("3.00", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal literal3 = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertSameValueAs("lexical form does not affect value", literal, literal2);
        this.assertSameValueAs("lexical form does not affect value", literal3, literal2);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (!((Object)literal).equals(literal2) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (boolean)((Object)literal).equals(literal3));
        literal = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        literal2 = this.m.createTypedLiteral(" 3 ", (RDFDatatype)XSDDatatype.XSDint);
        literal3 = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("lexical form does not affect value", literal, literal2);
        this.assertSameValueAs("lexical form does not affect value", literal3, literal2);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (!((Object)literal).equals(literal2) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (boolean)((Object)literal).equals(literal3));
    }

    private void assertDiffer(String string, Literal literal, Literal literal2) {
        TestTypedLiterals.assertTrue((String)string, (!literal.sameValueAs(literal2) ? 1 : 0) != 0);
    }

    private void assertSameValueAs(String string, Literal literal, Literal literal2) {
        TestTypedLiterals.assertTrue((String)string, (boolean)literal.sameValueAs(literal2));
    }

    private void assertFloatEquals(String string, double d, double d2) {
        TestTypedLiterals.assertTrue((String)string, (Math.abs(d - d2) < 0.001 ? 1 : 0) != 0);
    }

    public void checkIllegalLiteral(String string, RDFDatatype rDFDatatype) {
        try {
            Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
            literal.getValue();
            TestTypedLiterals.assertTrue((String)("Failed to catch '" + string + "' as an illegal " + rDFDatatype), (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
    }

    public void checkLegalLiteral(String string, RDFDatatype rDFDatatype, Class clazz, Object object) {
        Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
        TestTypedLiterals.assertEquals(literal.getValue().getClass(), (Object)clazz);
        TestTypedLiterals.assertEquals((Object)literal.getValue(), (Object)object);
        TestTypedLiterals.assertEquals((Object)literal.getDatatype(), (Object)rDFDatatype);
    }

    public void checkSerialization(String string, RDFDatatype rDFDatatype) {
        Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
        TestTypedLiterals.assertEquals((String)literal.getValue().toString(), (String)string);
    }

    public void assertIteratorValues(Iterator iterator, Object[] objectArray) {
        int n;
        boolean[] blArray = new boolean[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            blArray[n] = false;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!e.equals(objectArray[i])) continue;
                bl = true;
                blArray[i] = true;
            }
            TestTypedLiterals.assertTrue((boolean)bl);
        }
        for (n = 0; n < objectArray.length; ++n) {
            TestTypedLiterals.assertTrue((boolean)blArray[n]);
        }
    }
}

