/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.publish.uddi.wsdl;

import de.uka.cmtm.serviceregistry.publish.uddi.UddiTModels;
import de.uka.cmtm.serviceregistry.publish.uddi.UddiUtils;
import de.uka.cmtm.serviceregistry.publish.uddi.WsdlPublisher;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.InstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class WsdlPublisherV01_08
implements WsdlPublisher {
    public static final String WSDL_SPEC_TMODEL_KEY_VALUE = "wsdlSpec";
    private UddiUtils uddiUtils;

    public WsdlPublisherV01_08(UDDIProxy uddiProxy, AuthToken authToken) {
        this.uddiUtils = new UddiUtils(uddiProxy, authToken);
    }

    public void publishWsdl(String wsdlUrl, String businessKey) throws IOException {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            Definition wsdl = reader.readWSDL(wsdlUrl);
            Collection services = wsdl.getServices().values();
            TModel wsdlRefTModel = this.publishWsdlReference(wsdl.getTargetNamespace(), wsdl.getDocumentBaseURI());
            for (Service service : services) {
                CategoryBag categoryBag = new CategoryBag();
                this.addServiceCategoryBagKeyedReferences(categoryBag, service);
                if (categoryBag.size() == 0) {
                    categoryBag = null;
                }
                BusinessService businessService = this.uddiUtils.publishService(service.getQName().getLocalPart(), null, businessKey, categoryBag);
                Collection ports = service.getPorts().values();
                for (Port port : ports) {
                    List exElements = port.getExtensibilityElements();
                    String httpAddress = null;
                    for (ExtensibilityElement element : exElements) {
                        String uri;
                        if (!(element instanceof SOAPAddress) || !(uri = ((SOAPAddress)element).getLocationURI()).startsWith("http")) continue;
                        httpAddress = uri;
                    }
                    if (httpAddress == null) {
                        throw new IllegalArgumentException("The WSDL does not contain a SOAP http access point.");
                    }
                    TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
                    TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo(wsdlRefTModel.getTModelKey());
                    InstanceDetails instanceDetails = new InstanceDetails();
                    OverviewDoc oDoc = new OverviewDoc();
                    oDoc.setOverviewURL(String.valueOf(wsdl.getDocumentBaseURI()) + "#" + port.getName());
                    instanceDetails.setOverviewDoc(oDoc);
                    tModelInstanceInfo.setInstanceDetails(instanceDetails);
                    tModelInstanceDetails.add(tModelInstanceInfo);
                    this.addBindingTemplateTModelInstaceInfos(tModelInstanceDetails, port);
                    AccessPoint ap = new AccessPoint(httpAddress, "http");
                    this.uddiUtils.publishBindingTemplate(ap, businessService.getServiceKey(), tModelInstanceDetails);
                }
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Communication or WSDL problem.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void addBindingTemplateTModelInstaceInfos(TModelInstanceDetails tModelInstanceDetails, Port port) throws UDDIException, TransportException {
    }

    protected void addServiceCategoryBagKeyedReferences(CategoryBag categoryBag, Service service) throws UDDIException, TransportException {
    }

    private TModel publishWsdlReference(String tModelName, String wsdlUri) throws UDDIException, TransportException {
        CategoryBag cBag = new CategoryBag();
        KeyedReference kRef = new KeyedReference();
        kRef.setTModelKey(UddiTModels.TYPES.getKey());
        kRef.setKeyName(UddiTModels.TYPES.getName());
        kRef.setKeyValue(WSDL_SPEC_TMODEL_KEY_VALUE);
        cBag.add(kRef);
        return this.uddiUtils.publishTModel(tModelName, "WSDL Reference", wsdlUri, cBag);
    }

    public void publishWsdl(String wsdlUrl, String businessName, String businessDescription) throws IOException {
        BusinessEntity businessEntity = null;
        try {
            businessEntity = this.uddiUtils.publishBusiness(businessName, businessDescription);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Communication or WSDL problem.");
            ioe.initCause(e);
            throw ioe;
        }
        if (businessEntity != null) {
            this.publishWsdl(wsdlUrl, businessEntity.getBusinessKey());
        }
    }
}

