/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class OWLFBRuleReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new OWLFBRuleReasonerFactory();
    public static final String URI = "http://jena.hpl.hp.com/2003/OWLFBRuleReasoner";
    protected Model capabilities;

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    public Reasoner create(Resource resource) {
        OWLFBRuleReasoner oWLFBRuleReasoner = new OWLFBRuleReasoner(this);
        if (resource != null) {
            Boolean bl;
            Boolean bl2 = Util.checkBinaryPredicate(ReasonerVocabulary.PROPderivationLogging, resource);
            if (bl2 != null) {
                oWLFBRuleReasoner.setDerivationLogging(bl2);
            }
            if ((bl = Util.checkBinaryPredicate(ReasonerVocabulary.PROPtraceOn, resource)) != null) {
                oWLFBRuleReasoner.setTraceOn(bl);
            }
        }
        return oWLFBRuleReasoner;
    }

    public Model getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ModelFactory.createDefaultModel();
            Resource resource = this.capabilities.createResource(this.getURI());
            resource.addProperty(ReasonerVocabulary.nameP, "OWL BRule Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Experimental OWL reasoner.\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.supportsP, OWL.ObjectProperty).addProperty(ReasonerVocabulary.supportsP, OWL.DatatypeProperty).addProperty(ReasonerVocabulary.supportsP, OWL.FunctionalProperty).addProperty(ReasonerVocabulary.supportsP, OWL.SymmetricProperty).addProperty(ReasonerVocabulary.supportsP, OWL.TransitiveProperty).addProperty(ReasonerVocabulary.supportsP, OWL.InverseFunctionalProperty).addProperty(ReasonerVocabulary.supportsP, OWL.hasValue).addProperty(ReasonerVocabulary.supportsP, OWL.intersectionOf).addProperty(ReasonerVocabulary.supportsP, OWL.unionOf).addProperty(ReasonerVocabulary.supportsP, OWL.minCardinality).addProperty(ReasonerVocabulary.supportsP, OWL.maxCardinality).addProperty(ReasonerVocabulary.supportsP, OWL.cardinality).addProperty(ReasonerVocabulary.supportsP, OWL.someValuesFrom).addProperty(ReasonerVocabulary.supportsP, OWL.allValuesFrom).addProperty(ReasonerVocabulary.supportsP, OWL.sameAs).addProperty(ReasonerVocabulary.supportsP, OWL.differentFrom).addProperty(ReasonerVocabulary.supportsP, OWL.disjointWith).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.capabilities;
    }

    public String getURI() {
        return URI;
    }
}

