/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.FileManager;
import java.util.Iterator;
import junit.framework.TestCase;

public class OWLConsistencyTest
extends TestCase {
    public static final String BASE_DIR = "file:testing/reasoners/owl/";
    protected String tbox;
    protected String abox;
    protected int expected;
    protected ReasonerFactory rf;
    public static final int INCONSISTENT = 1;
    public static final int WARNINGS = 2;
    public static final int CLEAN = 3;
    protected Object culprit;

    public OWLConsistencyTest(String string, String string2, int n, Object object) {
        super(string2);
        this.tbox = string;
        this.abox = string2;
        this.expected = n;
        this.culprit = object;
    }

    public OWLConsistencyTest(OWLConsistencyTest oWLConsistencyTest, String string, ReasonerFactory reasonerFactory) {
        super(string + ":" + oWLConsistencyTest.abox);
        this.tbox = oWLConsistencyTest.tbox;
        this.abox = oWLConsistencyTest.abox;
        this.expected = oWLConsistencyTest.expected;
        this.culprit = oWLConsistencyTest.culprit;
        this.rf = reasonerFactory;
    }

    public void setReasonerFactory(ReasonerFactory reasonerFactory) {
        this.rf = reasonerFactory;
    }

    public ValidityReport testResults() {
        Model model = FileManager.get().loadModel(BASE_DIR + this.tbox);
        Model model2 = FileManager.get().loadModel(BASE_DIR + this.abox);
        Reasoner reasoner = this.rf.create(null);
        model2.add(model);
        InfModel infModel = ModelFactory.createInfModel(reasoner, model2);
        return infModel.validate();
    }

    public void runTest() {
        ValidityReport validityReport = this.testResults();
        switch (this.expected) {
            case 1: {
                OWLConsistencyTest.assertTrue((String)"expected inconsistent", (!validityReport.isValid() ? 1 : 0) != 0);
                break;
            }
            case 2: {
                OWLConsistencyTest.assertTrue((String)"expected just warnings but reports not valid", (boolean)validityReport.isValid());
                OWLConsistencyTest.assertFalse((String)"expected warnings but reports clean", (boolean)validityReport.isClean());
                break;
            }
            case 3: {
                OWLConsistencyTest.assertTrue((String)"expected clean", (boolean)validityReport.isClean());
            }
        }
        if (this.culprit != null) {
            boolean bl = false;
            Iterator iterator = validityReport.getReports();
            while (iterator.hasNext()) {
                ValidityReport.Report report = (ValidityReport.Report)iterator.next();
                if (report.getExtension() == null || !report.getExtension().equals(this.culprit)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OWLConsistencyTest.assertTrue((String)("Expcted to find a culprint " + this.culprit), (boolean)false);
            }
        }
    }
}

