/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.style.SubclassesRestrictionDuplicatesThatOfSuperTest;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class SubclassRestrictionDuplicatesThatOfSuperTestCase
extends AbstractJenaTestCase {
    public void testMinCardinalityDuplicated() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLNamedClass d = this.owlModel.createOWLNamedClass("D");
        b.addSuperclass(a);
        c.addSuperclass(b);
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        OWLMinCardinality restrA = this.owlModel.createOWLMinCardinality(p, 1, d);
        OWLMinCardinality restrB = this.owlModel.createOWLMinCardinality(p, 1, d);
        OWLAllValuesFrom restrC = this.owlModel.createOWLAllValuesFrom((RDFProperty)p, d);
        SubclassRestrictionDuplicatesThatOfSuperTestCase.assertTrue((boolean)restrA.equalsStructurally(restrB));
        a.addSuperclass(restrA);
        a.addSuperclass(restrC);
        c.addSuperclass(restrB);
        SubclassRestrictionDuplicatesThatOfSuperTestCase.assertTrue((boolean)SubclassesRestrictionDuplicatesThatOfSuperTest.fails(c));
        SubclassesRestrictionDuplicatesThatOfSuperTest.fix(c);
        SubclassRestrictionDuplicatesThatOfSuperTestCase.assertFalse((boolean)SubclassesRestrictionDuplicatesThatOfSuperTest.fails(c));
    }

    public void testExistentialDuplicated() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        b.addSuperclass(a);
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        OWLSomeValuesFrom restrA = this.owlModel.createOWLSomeValuesFrom((RDFProperty)p, c);
        OWLSomeValuesFrom restrB = this.owlModel.createOWLSomeValuesFrom((RDFProperty)p, c);
        a.addSuperclass(restrA);
        b.addSuperclass(restrB);
        SubclassRestrictionDuplicatesThatOfSuperTestCase.assertTrue((boolean)SubclassesRestrictionDuplicatesThatOfSuperTest.fails(b));
        SubclassesRestrictionDuplicatesThatOfSuperTest.fix(b);
        SubclassRestrictionDuplicatesThatOfSuperTestCase.assertFalse((boolean)SubclassesRestrictionDuplicatesThatOfSuperTest.fails(b));
    }
}

