/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;

public abstract class AbstractPropertyValuesComponent
extends JComponent
implements PropertyValuesComponent {
    private final RDFProperty predicate;
    private RDFResource subject;

    protected AbstractPropertyValuesComponent(RDFProperty predicate) {
        this.predicate = predicate;
        this.setLayout(new BorderLayout());
    }

    protected PropertyValueEditor getEditor(Object value) {
        RDFResource subject = this.getSubject();
        RDFProperty predicate = this.getPredicate();
        return PropertyValueEditorManager.getEditor(subject, predicate, value);
    }

    protected String getLabel() {
        RDFProperty property = this.getPredicate();
        String text = property.getBrowserText();
        if (this.getOWLModel().getProject().getPrettyPrintSlotWidgetLabels()) {
            text = StringUtilities.symbolToLabel((String)text);
        }
        return text;
    }

    protected Object getObject() {
        Collection objects = this.getObjects();
        if (objects.isEmpty()) {
            return null;
        }
        return objects.iterator().next();
    }

    public Collection getObjects() {
        return this.getObjects(false);
    }

    public Collection getObjects(boolean includingSubproperties) {
        RDFResource subject = this.getSubject();
        if (subject != null) {
            return subject.getPropertyValues(this.getPredicate(), includingSubproperties);
        }
        return Collections.EMPTY_LIST;
    }

    protected OWLModel getOWLModel() {
        return this.predicate.getOWLModel();
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public RDFSClass getSubjectType() {
        RDFResource subject = this.getSubject();
        if (subject != null) {
            return subject.getRDFType();
        }
        return null;
    }

    protected boolean hasHasValueRestriction() {
        if (this.getSubject() != null && this.getPredicate() != null) {
            return !this.getSubject().getHasValuesOnTypes(this.getPredicate()).isEmpty();
        }
        return false;
    }

    protected boolean hasOnlyEditableValues() {
        Collection values = this.getObjects();
        TripleStoreModel tsm = this.getOWLModel().getTripleStoreModel();
        for (Object value : values) {
            if (tsm.isEditableTriple(this.getSubject(), this.getPredicate(), value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnumerationProperty() {
        if (this.subject != null) {
            for (RDFSClass type : this.subject.getRDFTypes()) {
                OWLNamedClass namedClass;
                RDFResource all;
                if (!(type instanceof OWLNamedClass) || !((all = (namedClass = (OWLNamedClass)type).getAllValuesFrom(this.predicate)) instanceof OWLNamedClass)) continue;
                OWLNamedClass typeClass = (OWLNamedClass)all;
                Iterator sit = typeClass.getSuperclasses(false).iterator();
                while (sit.hasNext()) {
                    if (!(sit.next() instanceof OWLEnumeratedClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setSubject(RDFResource subject) {
        this.subject = subject;
        this.repaint();
    }

    protected void showResource(RDFResource resource) {
        this.getOWLModel().getProject().show((Instance)resource);
    }
}

