/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.LogicClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.PropertiesClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.MultiWidgetPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;

public class SwitchableClassDefinitionWidget
extends MultiWidgetPropertyWidget {
    private Widget activeWidget;
    private static List registry = new ArrayList();

    static {
        registry.add(new LogicClassDefinitionWidgetType());
        registry.add(new PropertiesClassDefinitionWidgetType());
    }

    protected void createNestedWidgets() {
        String[] slotNames = new String[]{":DIRECT-TEMPLATE-SLOTS", ":DIRECT-SUPERCLASSES", ":DIRECT-INSTANCES", ":DIRECT-SUBCLASSES"};
        ArrayList clses = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"ClassView", (String)"True"));
        for (Class cls : clses) {
            try {
                SwitchableClassDefinitionWidget.registerSwitchableType((SwitchableType)cls.newInstance());
            }
            catch (InstantiationException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
            catch (IllegalAccessException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
            catch (ClassCastException e) {
                System.err.println("[SwitchableClassDefinitionWidget] plugin " + cls.getName() + " must implement SwitchableType - ignored");
            }
        }
        int s = 0;
        for (SwitchableType type : registry) {
            Class cls = type.getWidgetClassType();
            try {
                PropertyWidget widget = (PropertyWidget)cls.newInstance();
                this.addNestedWidget(widget, slotNames[s++], type.getButtonText(), type.getButtonText());
            }
            catch (Exception ex) {
                System.err.println("[SwitchableClassDefinitionWidget] " + ex);
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
    }

    public Class getActiveWidgetClass() {
        if (this.activeWidget != null) {
            return this.activeWidget.getClass();
        }
        SwitchableType type = (SwitchableType)registry.get(0);
        return type.getWidgetClassType();
    }

    protected void initAllPanel(JPanel allPanel, List widgets) {
        allPanel.setLayout(new BorderLayout());
        if (this.activeWidget != null) {
            allPanel.add("Center", (Component)this.activeWidget);
        } else {
            allPanel.add("Center", (Component)this.listWidgets().next());
        }
    }

    public void initialize() {
        super.initialize();
        this.setAllMode(true);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        if (cls.getKnowledgeBase() instanceof OWLModel) {
            OWLNamedClass namedClsMetaCls = ((OWLModel)cls.getKnowledgeBase()).getOWLNamedClassClass();
            return slot.getName().equals(":DIRECT-SUPERCLASSES") && facet == null && (namedClsMetaCls.equals(cls) || cls.hasSuperclass((Cls)namedClsMetaCls));
        }
        return false;
    }

    public static Iterator listSwitchableTypes() {
        return registry.iterator();
    }

    public static void registerSwitchableType(SwitchableType type) {
        for (SwitchableType switchableType : registry) {
            if (switchableType.getClass() != type.getClass()) continue;
            return;
        }
        registry.add(type);
    }

    public void setActiveType(Class widgetClassType) {
        Iterator it = this.listWidgets();
        while (it.hasNext()) {
            PropertyWidget widget = (PropertyWidget)it.next();
            if (widget.getClass() != widgetClassType) continue;
            this.activeWidget = widget;
            this.reinitAllPanel();
            this.revalidate();
            this.repaint();
            Object comp = this;
            while (comp != null && !(comp instanceof ResourceDisplay)) {
                comp = ((Component)comp).getParent();
            }
            if (comp instanceof ResourceDisplay) {
                ((ResourceDisplay)comp).updateInferredModeOfWidgets();
            }
            return;
        }
    }
}

