/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeNode;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeRoot;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ImportsTree
extends SelectableTree
implements HostResourceDisplay {
    private static int MAX_EXPANSIONS = 50;
    private OWLOntology rootOntology;

    public ImportsTree(OWLOntology rootOntology) {
        super(null, (LazyTreeRoot)new ImportsTreeRoot(rootOntology));
        this.rootOntology = rootOntology;
        this.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer()));
        this.setRootVisible(false);
        ComponentUtilities.fullSelectionExpand((JTree)((Object)this), (int)MAX_EXPANSIONS);
    }

    private void addResources(Set result, ImportsTreeNode node) {
        Object value = node.getUserObject();
        if (!result.contains(value)) {
            result.add(value);
            int i = 0;
            while (i < node.getChildCount()) {
                ImportsTreeNode childNode = (ImportsTreeNode)((Object)node.getChildAt(i));
                this.addResources(result, childNode);
                ++i;
            }
        }
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    public Set getSelectedResources() {
        HashSet<Object> result = new HashSet<Object>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                ImportsTreeNode node = (ImportsTreeNode)((Object)path.getLastPathComponent());
                result.add(node.getUserObject());
                ++i;
            }
        } else {
            LazyTreeRoot root = (LazyTreeRoot)this.getModel().getRoot();
            this.addResources(result, (ImportsTreeNode)((Object)root.getChildAt(0)));
        }
        return result;
    }

    public boolean displayHostResource(RDFResource resource) {
        boolean result = false;
        if (resource instanceof OWLOntology) {
            ArrayList<RDFResource> importsPath = new ArrayList<RDFResource>();
            importsPath.add(resource);
            Collection ontologies = this.rootOntology.getOWLModel().getOWLOntologies();
            while (!importsPath.contains(this.rootOntology)) {
                for (OWLOntology ont : ontologies) {
                    OWLOntology previous = (OWLOntology)importsPath.get(importsPath.size() - 1);
                    if (!ont.getImports().contains(previous.getURI().toString())) continue;
                    importsPath.add(ont);
                }
            }
            this.setSelectionPath(ComponentUtilities.getTreePath((JTree)((Object)this), importsPath));
            result = true;
        }
        return result;
    }
}

