/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.TestSuite;

public class TestGraphMem
extends AbstractTestGraph {
    public TestGraphMem(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphMem.class);
    }

    public Graph getGraph() {
        return new GraphMem();
    }

    public void testClosesReifier() {
        Graph graph = this.getGraph();
        SimpleReifier simpleReifier = (SimpleReifier)graph.getReifier();
        graph.close();
        TestGraphMem.assertTrue((boolean)simpleReifier.isClosed());
    }

    public void testBrokenIndexes() {
        Graph graph = this.getGraphWith("x R y; x S z");
        ExtendedIterator extendedIterator = graph.find(Node.ANY, Node.ANY, Node.ANY);
        extendedIterator.next();
        extendedIterator.remove();
        extendedIterator.next();
        extendedIterator.remove();
        TestGraphMem.assertFalse((boolean)graph.find(TestGraphMem.node("x"), Node.ANY, Node.ANY).hasNext());
        TestGraphMem.assertFalse((boolean)graph.find(Node.ANY, TestGraphMem.node("R"), Node.ANY).hasNext());
        TestGraphMem.assertFalse((boolean)graph.find(Node.ANY, Node.ANY, TestGraphMem.node("y")).hasNext());
    }

    public void testBrokenSubject() {
        Graph graph = this.getGraphWith("x brokenSubject y");
        ExtendedIterator extendedIterator = graph.find(TestGraphMem.node("x"), Node.ANY, Node.ANY);
        extendedIterator.next();
        extendedIterator.remove();
        TestGraphMem.assertFalse((boolean)graph.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenPredicate() {
        Graph graph = this.getGraphWith("x brokenPredicate y");
        ExtendedIterator extendedIterator = graph.find(Node.ANY, TestGraphMem.node("brokenPredicate"), Node.ANY);
        extendedIterator.next();
        extendedIterator.remove();
        TestGraphMem.assertFalse((boolean)graph.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenObject() {
        Graph graph = this.getGraphWith("x brokenObject y");
        ExtendedIterator extendedIterator = graph.find(Node.ANY, Node.ANY, TestGraphMem.node("y"));
        extendedIterator.next();
        extendedIterator.remove();
        TestGraphMem.assertFalse((boolean)graph.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testRemoveAllDoesntUseFind() {
        GraphMemWithoutFind graphMemWithoutFind = new GraphMemWithoutFind();
        TestGraphMem.graphAdd(graphMemWithoutFind, "x P y; a Q b");
        graphMemWithoutFind.getBulkUpdateHandler().removeAll();
        TestGraphMem.assertEquals((int)0, (int)graphMemWithoutFind.size());
    }

    public void testContainsConcreteDoesntUseFind() {
        GraphMemWithoutFind graphMemWithoutFind = new GraphMemWithoutFind();
        TestGraphMem.graphAdd(graphMemWithoutFind, "x P y; a Q b");
        TestGraphMem.assertTrue((boolean)graphMemWithoutFind.contains(TestGraphMem.triple("x P y")));
        TestGraphMem.assertTrue((boolean)graphMemWithoutFind.contains(TestGraphMem.triple("a Q b")));
        TestGraphMem.assertFalse((boolean)graphMemWithoutFind.contains(TestGraphMem.triple("a P y")));
        TestGraphMem.assertFalse((boolean)graphMemWithoutFind.contains(TestGraphMem.triple("y R b")));
    }

    protected final class GraphMemWithoutFind
    extends GraphMem {
        protected GraphMemWithoutFind() {
        }

        public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
            throw new JenaException("find is Not Allowed");
        }
    }
}

