/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.log;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.ui.icons.InferenceIcons;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;

public class DefaultConceptConsistencyLogRecord
extends ReasonerLogRecord {
    private RDFSClass aClass;
    private boolean consistent;
    private JLabel label;

    public DefaultConceptConsistencyLogRecord(RDFSClass aClass, boolean consistent, ReasonerLogRecord parent) {
        super(parent);
        String colour;
        this.aClass = aClass;
        this.consistent = consistent;
        this.label = new JLabel();
        if (consistent) {
            colour = "009900";
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GREEN)));
            this.label.setIcon(InferenceIcons.getInformationMessageIcon());
        } else {
            colour = "ff0000";
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.RED)));
            this.label.setIcon(OWLIcons.getOWLTestErrorIcon());
        }
        this.label.setText("<html><body color=\"" + colour + "\">" + this.getMessage() + "</body></html>");
    }

    public RDFSClass getInconsistentConcept() {
        return this.aClass;
    }

    public String getMessage() {
        String message = this.aClass.getBrowserText();
        message = this.consistent ? String.valueOf(message) + " is consistent" : String.valueOf(message) + " is inconsistent";
        return message;
    }

    public String toString() {
        return this.getMessage();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.label;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.label;
    }
}

