/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.AbstractConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.conditions.AddNamedClassAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionEditorPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssertedConditionsWidget
extends AbstractConditionsWidget {
    private AddNamedClassAction addNamedClassAction;
    private Action createExpressionAction = new AbstractAction("Create new expression", OWLIcons.getCreateIcon("OWLAnonymousClass")){

        public void actionPerformed(ActionEvent e) {
            AssertedConditionsWidget.this.table.selectNecessaryIfNothingSelected();
            AssertedConditionsWidget.this.table.createAndEditRow();
        }
    };
    private Action createRestrictionAction = new AbstractAction("Create restriction...", OWLIcons.getCreateIcon("OWLRestriction")){

        public void actionPerformed(ActionEvent e) {
            AssertedConditionsWidget.this.createRestriction();
        }
    };
    private DeleteRowAction deleteAction;
    private OWLTableAction deriveRestrictionAction = new AbstractOWLTableAction("Derive similar restriction...", OWLIcons.getAddIcon("OWLRestriction")){

        public void actionPerformed(ActionEvent e) {
            AssertedConditionsWidget.this.deriveRestriction();
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return AssertedConditionsWidget.this.tableModel.isAddEnabledAt(rowIndex) && AssertedConditionsWidget.this.table.getSelectedCls() instanceof OWLRestriction;
        }
    };
    private OWLTableAction negateAnonymousClsAction = new AbstractOWLTableAction("Negate expression", OWLIcons.getAddIcon("OWLComplementClass")){

        public void actionPerformed(ActionEvent e) {
            AssertedConditionsWidget.this.negateAnonymousClass();
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return AssertedConditionsWidget.this.tableModel.isAddEnabledAt(rowIndex) && AssertedConditionsWidget.this.table.getSelectedCls() instanceof OWLAnonymousClass;
        }
    };

    private void createRestriction() {
        OWLClassesTab owlClassesTab = this.table.getOWLClsesTab();
        this.table.selectNecessaryIfNothingSelected();
        Cls metaCls = this.getKnowledgeBase().getCls("owl:SomeValuesFromRestriction");
        try {
            try {
                this.beginTransaction("Create restriction at " + this.getEditedCls().getBrowserText());
                OWLRestriction newRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this.table), this.getEditedCls(), metaCls);
                if (newRestriction != null) {
                    this.table.addRestriction(newRestriction);
                    this.table.ensureEditedClassSelectedInExplorer(owlClassesTab);
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    private void deriveRestriction() {
        OWLRestriction restriction = (OWLRestriction)this.table.getSelectedCls();
        RDFSClass metaCls = restriction.getProtegeType();
        OWLProperty property = (OWLProperty)restriction.getOnProperty();
        String fillerText = restriction.getFillerText();
        try {
            try {
                this.beginTransaction("Derive restriction from " + restriction.getBrowserText() + " at " + this.getEditedCls().getBrowserText());
                OWLRestriction newRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this.table), this.getEditedCls(), metaCls, property, fillerText);
                if (newRestriction != null) {
                    OWLClassesTab owlClassesTab = this.table.getOWLClsesTab();
                    this.table.addRestriction(newRestriction);
                    this.table.ensureEditedClassSelectedInExplorer(owlClassesTab);
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void initialize() {
        Slot superclassesSlot = this.getKnowledgeBase().getSlot(":DIRECT-SUPERCLASSES");
        this.initialize("Asserted Conditions", superclassesSlot);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AssertedConditionsWidget.this.updateCreateActions();
            }
        });
    }

    protected void initializeButtons(LabeledComponent labeledComponent) {
        super.initializeButtons(labeledComponent);
        this.addNamedClassAction = new AddNamedClassAction(this.table);
        this.deleteAction = new DeleteRowAction(this.table){

            public void actionPerformed(ActionEvent e) {
                OWLClassesTab tab = AssertedConditionsWidget.this.table.getOWLClsesTab();
                super.actionPerformed(e);
                AssertedConditionsWidget.this.table.ensureEditedClassSelectedInExplorer(tab);
            }
        };
        labeledComponent.addHeaderSeparator();
        labeledComponent.addHeaderButton(this.createExpressionAction);
        labeledComponent.addHeaderButton(this.createRestrictionAction);
        labeledComponent.addHeaderButton((Action)this.addNamedClassAction);
        labeledComponent.addHeaderButton((Action)this.deleteAction);
        this.table.registerAction(this.deleteAction);
        this.table.registerActionSeparator();
        this.table.registerAction(this.deriveRestrictionAction);
        this.table.registerAction(this.negateAnonymousClsAction);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-SUPERCLASSES");
    }

    private void negateAnonymousClass() {
        OWLClassesTab owlClassesTab = this.table.getOWLClsesTab();
        OWLClassDisplay display = this.table.getOWLModel().getOWLClassDisplay();
        int rowIndex = this.table.getSelectedRow();
        Cls sel = this.table.getSelectedCls();
        String expression = sel.getBrowserText();
        if (sel instanceof OWLComplementClass) {
            int len = display.getOWLComplementOfSymbol().length();
            expression = expression.substring(len);
        } else {
            expression = String.valueOf(display.getOWLComplementOfSymbol()) + "(" + expression + ")";
        }
        this.table.setValueAt(expression, rowIndex, 0);
        this.table.ensureEditedClassSelectedInExplorer(owlClassesTab);
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (this.table != null) {
            this.updateCreateActions();
        }
    }

    private void updateCreateActions() {
        if (this.table.getSelectedRow() >= this.tableModel.getRowCount()) {
            this.table.setSelectedRow(-1);
        }
        boolean thing = this.getKnowledgeBase().getRootCls().equals(this.getEditedResource());
        if (this.table.getSelectedRowCount() == 1) {
            int row = this.table.getSelectedRow();
            boolean enabled = !thing && this.tableModel.isCreateEnabledAt(row);
            this.createExpressionAction.setEnabled(enabled);
            this.createRestrictionAction.setEnabled(enabled);
            this.addNamedClassAction.setEnabled(this.tableModel.isAddEnabledAt(row));
        } else {
            this.createExpressionAction.setEnabled(!thing);
            this.createRestrictionAction.setEnabled(!thing);
            this.addNamedClassAction.setEnabled(!thing);
        }
    }
}

