/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecCreatorByClassname;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.test.MockModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.NotFoundException;
import junit.framework.TestSuite;

public class TestModelSpecFactory
extends ModelTestBase {
    protected ModelSpecCreator createMock = new ModelSpecCreator(){

        public ModelSpec create(Resource resource, Model model) {
            return new MockModelSpec(resource, model);
        }
    };

    public TestModelSpecFactory(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecFactory.class);
    }

    public void testFindUniqueRootByType() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:x rdf:type eh:T; eh:y rdf:type eh:U");
        TestModelSpecFactory.assertEquals((Object)TestModelSpecFactory.resource("eh:x"), (Object)ModelSpecFactory.findRootByType(model, TestModelSpecFactory.resource("eh:T")));
    }

    public void testFindMissingRootByType() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:y rdf:type eh:U");
        Resource resource = TestModelSpecFactory.resource("eh:T");
        try {
            ModelSpecFactory.findRootByType(model, resource);
            TestModelSpecFactory.fail((String)"should trap missing root");
        }
        catch (BadDescriptionNoRootException badDescriptionNoRootException) {
            TestModelSpecFactory.assertEquals((Object)resource, (Object)badDescriptionNoRootException.type);
            TestModelSpecFactory.assertSame((Object)model, (Object)badDescriptionNoRootException.badModel);
        }
    }

    public void testFindMultipleRootByType() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:x rdf:type eh:T; eh:y rdf:type eh:T");
        Resource resource = TestModelSpecFactory.resource("eh:T");
        try {
            ModelSpecFactory.findRootByType(model, resource);
            TestModelSpecFactory.fail((String)"should trap multiple roots");
        }
        catch (BadDescriptionMultipleRootsException badDescriptionMultipleRootsException) {
            TestModelSpecFactory.assertEquals((Object)resource, (Object)badDescriptionMultipleRootsException.type);
            TestModelSpecFactory.assertSame((Object)model, (Object)badDescriptionMultipleRootsException.badModel);
        }
    }

    public void testFindSpecificTypeTrivial() {
        Model model = this.fullModel("eh:root rdf:type eh:T");
        Resource resource = TestModelSpecFactory.resource("eh:T");
        Resource resource2 = model.createResource("eh:root");
        TestModelSpecFactory.assertEquals((Object)resource, (Object)ModelSpecFactory.findSpecificType(resource2, resource));
    }

    public void testFindSpecificTypeWithIrrelevantOtherType() {
        Model model = this.fullModel("eh:root rdf:type eh:T; eh:root rdf:type eh:Other");
        Resource resource = TestModelSpecFactory.resource("eh:T");
        Resource resource2 = model.createResource("eh:root");
        TestModelSpecFactory.assertEquals((Object)resource, (Object)ModelSpecFactory.findSpecificType(resource2, resource));
    }

    public void testFactoryReturnsAModelSpec() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        Resource resource = model.createResource("eh:Root");
        ModelSpec modelSpec = ModelSpecFactory.createSpec(model, resource);
    }

    public void testModelAccessible() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        Resource resource = model.createResource("eh:Root");
        ModelSpec modelSpec = ModelSpecFactory.createSpec(model, resource);
        TestModelSpecFactory.assertNotNull((Object)modelSpec.getDescription());
    }

    public void testFactoryNoRoot() {
        Model model = TestModelSpecFactory.modelWithStatements("");
        try {
            ModelSpecFactory.createSpec(model);
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelSpecFactory.pass();
        }
    }

    public void testGEMSmultipleRoots() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:ModelSpec; eh:Fake rdf:type jms:PlainModelSpec");
        try {
            ModelSpecFactory.createSpec(model);
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelSpecFactory.pass();
        }
    }

    public void testDefaultCreate() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        ModelSpec modelSpec = ModelSpecFactory.createSpec(model);
        Model model2 = modelSpec.createModel();
        TestModelSpecFactory.assertNotNull((Object)model2);
    }

    public void testMatchingModelSpec() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type jms:PlainModelSpec");
        ModelSpec modelSpec = ModelSpecFactory.createSpec(model);
    }

    public void testLoadsCorrectModelSpec() {
        Model model = TestModelSpecFactory.modelWithStatements("eh:Root rdf:type eh:MockSpec; eh:MockSpec rdfs:subClassOf jms:ModelSpec");
        ModelSpec modelSpec = ModelSpecFactory.createSpec(ModelSpecCreatorRegistry.registryWith(TestModelSpecFactory.resource("eh:MockSpec"), this.createMock), model);
        TestModelSpecFactory.assertTrue((boolean)(modelSpec instanceof MockModelSpec));
    }

    public void testCreateCreator() {
        String string = "com.hp.hpl.jena.rdf.model.test.MockModelSpec";
        ModelSpecCreatorByClassname modelSpecCreatorByClassname = new ModelSpecCreatorByClassname(string);
        ModelSpec modelSpec = modelSpecCreatorByClassname.create(TestModelSpecFactory.resource("root"), TestModelSpecFactory.modelWithStatements(""));
        TestModelSpecFactory.assertEquals((String)string, (String)modelSpec.getClass().getName());
    }

    public void testCreateCreatorDeferred() {
        String string = "lets.go.gathering.nuts.in.May";
        ModelSpecCreatorByClassname modelSpecCreatorByClassname = new ModelSpecCreatorByClassname(string);
    }

    public void testRegistryDetectsMissingConfig() {
        try {
            new ModelSpecCreatorRegistry("there/is/no/such/config.file");
            TestModelSpecFactory.fail((String)"there should be no such configuration file found");
        }
        catch (NotFoundException notFoundException) {
            TestModelSpecFactory.pass();
        }
    }

    public void testRegistryIgnoresMissingConfig() {
        new ModelSpecCreatorRegistry("there/is/no/such/config.file", true);
    }

    public void testRegistryDetectSuppliedConfig() {
        Model model = TestModelSpecFactory.modelWithStatements("");
        Resource resource = model.createResource("eh:pseudo-modelspec-type");
        ModelSpec modelSpec = new ModelSpecCreatorRegistry("testing/modelspecs/modelspec-config.n3").getCreator(TestModelSpecFactory.resource("eh:pseudo-modelspec-type")).create(resource, model);
        TestModelSpecFactory.assertTrue((boolean)(modelSpec instanceof MockModelSpec));
    }

    protected Model fullModel(String string) {
        return ModelSpecFactory.withSchema(TestModelSpecFactory.modelWithStatements(string));
    }
}

