/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.regression.DiHyperCube;
import com.hp.hpl.jena.regression.GetModel;
import com.hp.hpl.jena.regression.HyperCube;
import java.util.Random;

public class testMatch {
    static int QUANTITY = 1;
    static int DIMENSION = 6;
    private String test;
    private Random random;
    private int n = 0;
    private Model m1;
    private Model m2;
    private GetModel gm1;
    private GetModel gm2;
    private boolean inError = false;

    protected static void doTest(GetModel getModel) {
        new testMatch(4011, getModel).test();
        System.out.println("End testMatch");
    }

    testMatch(int n, GetModel getModel) {
        this.test = "testMatch seed=" + n;
        this.random = new Random(n);
        this.gm1 = getModel;
        this.gm2 = getModel;
    }

    void test() {
        this.test2HyperCube(DIMENSION, QUANTITY);
        this.test4DiHyperCube(DIMENSION, QUANTITY, true);
        this.test4DiHyperCube(DIMENSION, QUANTITY, false);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, true);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, false);
        if (QUANTITY > 5) {
            this.test2DiHyperCube(DIMENSION, QUANTITY, true);
            this.test2DiHyperCube(DIMENSION, QUANTITY, false);
            this.test4HyperCube(DIMENSION, QUANTITY, true);
            this.test4HyperCube(DIMENSION, QUANTITY, false);
        }
    }

    private void test2DiHyperCube(int n, int n2, boolean bl) {
        try {
            int n4 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                int n5;
                int n6;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                while (bl != DiHyperCube.equal(n6 = this.random.nextInt(n4), n5 = this.random.nextInt(n4))) {
                }
                ++this.n;
                new DiHyperCube(n, this.m1).dupe(n6).dupe(n6).dupe(n6);
                ++this.n;
                new DiHyperCube(n, this.m2).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == bl) continue;
                this.error();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4DiHyperCube(int n, int n2, boolean bl) {
        try {
            int n4 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                int n5;
                int n6;
                int n7;
                int n8;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    n8 = this.random.nextInt(n4);
                    n6 = this.random.nextInt(n4);
                } while (bl != DiHyperCube.equal(n8, n7 = this.random.nextInt(n4), n6, n5 = this.random.nextInt(n4)));
                ++this.n;
                new DiHyperCube(n, this.m1).dupe(n8).dupe(n8).dupe(n8).dupe(n7).dupe(n7).dupe(n7);
                ++this.n;
                new DiHyperCube(n, this.m2).dupe(n6).dupe(n6).dupe(n6).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == bl) continue;
                System.out.println("(" + n8 + "," + n7 + "),(" + n6 + "," + n5 + ")");
                this.error();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test2HyperCube(int n, int n2) {
        try {
            int n4 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                int n5 = this.random.nextInt(n4);
                int n6 = this.random.nextInt(n4);
                ++this.n;
                new HyperCube(n, this.m1).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                new HyperCube(n, this.m2).dupe(n6).dupe(n6).dupe(n6);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2)) continue;
                this.error();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4HyperCube(int n, int n2, boolean bl) {
        try {
            int n4 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                int n5;
                int n6;
                int n7;
                int n8;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    n8 = this.random.nextInt(n4);
                    n6 = this.random.nextInt(n4);
                } while (bl != HyperCube.equal(n8, n7 = this.random.nextInt(n4), n6, n5 = this.random.nextInt(n4)));
                ++this.n;
                new HyperCube(n, this.m1).dupe(n8).dupe(n8).dupe(n8).dupe(n7).dupe(n7).dupe(n7);
                ++this.n;
                new HyperCube(n, this.m2).dupe(n6).dupe(n6).dupe(n6).dupe(n5).dupe(n5).dupe(n5);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == bl) continue;
                System.out.println("(" + n8 + "," + n7 + "),(" + n6 + "," + n5 + ")");
                this.error();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void test4ToggleHyperCube(int n, int n2, boolean bl) {
        try {
            int n4 = 1 << n;
            for (int i = 0; i < n2; ++i) {
                int n5;
                int n6;
                int n7;
                int n8;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    n8 = this.random.nextInt(n4);
                    n6 = this.random.nextInt(n4);
                } while (bl != HyperCube.equal(n8, n7 = this.random.nextInt(n4), n6, n5 = this.random.nextInt(n4)));
                ++this.n;
                new HyperCube(n, this.m1).toggle(n8, n7);
                ++this.n;
                new HyperCube(n, this.m2).toggle(n6, n5);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == bl) continue;
                System.out.println("(" + n8 + "," + n7 + "),(" + n6 + "," + n5 + ")");
                this.error();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    private void error() {
        System.out.println(this.test + ": failed test " + Integer.toString(this.n));
        this.inError = true;
    }

    public void error(Exception exception) {
        System.out.println("Test Failed: " + this.test + " " + this.n + " " + exception.toString());
        this.inError = true;
        exception.printStackTrace();
    }

    public boolean getErrors() {
        return this.inError;
    }
}

