/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class MultilingualBrowserTextTestCase
extends AbstractJenaTestCase {
    public void testDefaultBrowserText() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFIndividual instance = cls.createRDFIndividual("Instance");
        MultilingualBrowserTextTestCase.assertEquals((String)instance.getName(), (String)instance.getBrowserText());
    }

    public void testLabelBrowserText() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        RDFIndividual individual = namedClass.createRDFIndividual("Instance");
        namedClass.setDirectBrowserSlot(this.owlModel.getRDFSLabelProperty());
        individual.addLabel("inst", null);
        individual.addLabel("deutsch", "de");
        MultilingualBrowserTextTestCase.assertEquals((String)"inst", (String)individual.getBrowserText());
        RDFProperty metaSlot = this.owlModel.getRDFProperty(ProtegeNames.getDefaultLanguageSlotName());
        OWLOntology oi = this.owlModel.getDefaultOWLOntology();
        oi.setPropertyValue(metaSlot, "de");
        MultilingualBrowserTextTestCase.assertEquals((String)"deutsch", (String)individual.getBrowserText());
    }
}

