/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialFillerProvider;

public class ExistentialFillerProviderTestCase
extends AbstractJenaTestCase {
    public void testNamedSuperClasses() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsB));
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC));
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(2, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsB, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsC, prov.getFillers());
    }

    public void testNamedEquivalentClasses() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        cls.addEquivalentClass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsB));
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC));
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(2, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsB, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsC, prov.getFillers());
    }

    public void testNonTransitiveChain() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        OWLSomeValuesFrom nestedSomeValuesFrom = this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC);
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, nestedSomeValuesFrom));
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(1, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)nestedSomeValuesFrom, prov.getFillers());
    }

    public void testTransitiveChain() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        prop.setTransitive(true);
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        OWLSomeValuesFrom nestedSomeValuesFrom = this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC);
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, nestedSomeValuesFrom));
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(2, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsC, prov.getFillers());
    }

    public void testIntersectionEquivalentClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        OWLIntersectionClass intersectionClass = this.owlModel.createOWLIntersectionClass();
        OWLSomeValuesFrom someValuesFromB = this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsB);
        OWLSomeValuesFrom someValuesFromC = this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC);
        intersectionClass.addOperand(someValuesFromB);
        intersectionClass.addOperand(someValuesFromC);
        cls.addEquivalentClass(intersectionClass);
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(2, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsB, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsC, prov.getFillers());
    }

    public void testFillerCycle() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, cls));
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        cls.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(1, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)cls, prov.getFillers());
    }

    public void testHierarchyCycle() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        OWLObjectProperty prop = this.owlModel.createOWLObjectProperty("p");
        clsA.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, clsC));
        clsA.addSuperclass(clsB);
        clsB.addSuperclass(clsA);
        ExistentialFillerProvider prov = new ExistentialFillerProvider(prop);
        clsA.accept(prov);
        ExistentialFillerProviderTestCase.assertSize(1, prov.getFillers());
        ExistentialFillerProviderTestCase.assertContains((Object)clsC, prov.getFillers());
    }
}

