/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultFrame;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class DefaultInstance
extends DefaultFrame
implements Instance {
    DefaultInstance(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    protected DefaultInstance() {
    }

    public void addInstanceListener(InstanceListener instanceListener) {
        this.getDefaultKnowledgeBase().addInstanceListener(this, instanceListener);
    }

    public Frame deepCopy(KnowledgeBase knowledgeBase, Map map) {
        return this.copy(knowledgeBase, map, true);
    }

    public Frame shallowCopy(KnowledgeBase knowledgeBase, Map map) {
        return this.copy(knowledgeBase, map, false);
    }

    public Frame copy(KnowledgeBase knowledgeBase, Map map, boolean bl) {
        Instance instance;
        KnowledgeBase knowledgeBase2 = this.getKnowledgeBase();
        if (knowledgeBase == null) {
            knowledgeBase = knowledgeBase2;
        }
        if (map == null) {
            map = ModelUtilities.createValueMap(knowledgeBase2, knowledgeBase);
        }
        if ((instance = (Instance)map.get(this)) == null) {
            String string = null;
            Collection collection = this.getCopyTypes(map);
            instance = knowledgeBase.createInstance(string, collection);
            map.put(this, instance);
        }
        return super.copy(knowledgeBase, map, bl);
    }

    private Collection getCopyTypes(Map map) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (Cls cls : this.getDirectTypes()) {
            Cls cls2 = (Cls)map.get(cls);
            arrayList.add(cls2);
        }
        return arrayList;
    }

    public String getBrowserText() {
        return this.getDefaultKnowledgeBase().getBrowserText(this);
    }

    public Cls getDirectType() {
        KnowledgeBase knowledgeBase = this.getDefaultKnowledgeBase();
        return knowledgeBase == null ? null : knowledgeBase.getDirectType(this);
    }

    public Collection getDirectTypes() {
        KnowledgeBase knowledgeBase = this.getDefaultKnowledgeBase();
        return knowledgeBase == null ? null : knowledgeBase.getDirectTypes(this);
    }

    public Object getOwnFacetValue(Slot slot, Facet facet) {
        return this.getDirectType().getTemplateFacetValue(slot, facet);
    }

    public Collection getOwnFacetValues(Slot slot, Facet facet) {
        return this.getDirectType().getTemplateFacetValues(slot, facet);
    }

    public Collection getReachableSimpleInstances() {
        Collection collection = CollectionUtilities.createCollection(this);
        return this.getDefaultKnowledgeBase().getReachableSimpleInstances(collection);
    }

    public boolean hasDirectType(Cls cls) {
        return this.getDefaultKnowledgeBase().hasDirectType(this, cls);
    }

    public boolean hasType(Cls cls) {
        return this.getDefaultKnowledgeBase().hasType(this, cls);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        this.getDefaultKnowledgeBase().removeInstanceListener(this, instanceListener);
    }

    public Instance setDirectType(Cls cls) {
        return this.getDefaultKnowledgeBase().setDirectType(this, cls);
    }

    public Instance setDirectTypes(Collection collection) {
        return this.getDefaultKnowledgeBase().setDirectTypes(this, collection);
    }

    public void addDirectType(Cls cls) {
        this.getDefaultKnowledgeBase().addDirectType(this, cls);
    }

    public void removeDirectType(Cls cls) {
        this.getDefaultKnowledgeBase().removeDirectType(this, cls);
    }

    public void moveDirectType(Cls cls, int n) {
        this.getDefaultKnowledgeBase().moveDirectType(this, cls, n);
    }
}

