/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.shared.JenaException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRDQLMatch
extends TestCase {
    String pfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^hi/USING ex FOR  <http://example.org/> ";
    String sfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /there$/ USING ex FOR  <http://example.org/> ";
    String ipfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^hi/iUSING ex FOR  <http://example.org/> ";
    String isfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /there$/i USING ex FOR  <http://example.org/> ";
    String epfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^yo_their/ USING ex FOR  <http://example.org/> ";
    String unboundQueryString = "SELECT * WHERE (?s, ?p, ?o) and ?o =~ /hi/";
    String lobjQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /789obj/ USING ex FOR  <http://example.org/> ";
    String lsubjQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?s =~ /789subj/ USING ex FOR  <http://example.org/> ";
    String lpredQueryString = "SELECT * WHERE (<ex:subj>, ?p, ?o) and ?p =~ /789pred/ USING ex FOR  <http://example.org/> ";

    public TestRDQLMatch(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDQLMatch.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestRDQLMatch.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        DBConnection dBConnection;
        try {
            dBConnection = (DBConnection)TestRDQLMatch.makeTestConnection();
            dBConnection.cleanDB();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
        return dBConnection;
    }

    public void testMatches() throws Exception {
        Class.forName(TestPackage.M_DBDRIVER_CLASS);
        IDBConnection iDBConnection = TestRDQLMatch.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        IRDBDriver iRDBDriver = null;
        iRDBDriver = iDBConnection.getDriver();
        Resource resource = ResourceFactory.createResource("http://example.org/subj");
        Property property = ResourceFactory.createProperty("http://example.org/prop");
        Resource resource2 = ResourceFactory.createResource("http://example.org/obj");
        Statement statement = ResourceFactory.createStatement(resource, property, resource2);
        Literal literal = ResourceFactory.createPlainLiteral("hi there");
        Statement statement2 = ResourceFactory.createStatement(resource, property, literal);
        Literal literal2 = ResourceFactory.createPlainLiteral("hi there again");
        Statement statement3 = ResourceFactory.createStatement(resource, property, literal2);
        Literal literal3 = ResourceFactory.createPlainLiteral("HI THERE");
        Statement statement4 = ResourceFactory.createStatement(resource, property, literal3);
        Literal literal4 = ResourceFactory.createPlainLiteral("HI THERE AGAIN");
        Statement statement5 = ResourceFactory.createStatement(resource, property, literal4);
        Literal literal5 = ResourceFactory.createPlainLiteral("yo_their");
        Statement statement6 = ResourceFactory.createStatement(resource, property, literal5);
        Literal literal6 = ResourceFactory.createPlainLiteral("yo their");
        Statement statement7 = ResourceFactory.createStatement(resource, property, literal6);
        String string = "0123456789";
        String string2 = "http://example.org/long#";
        long l = iRDBDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        Resource resource3 = ResourceFactory.createResource(string2 + "subj");
        Property property2 = ResourceFactory.createProperty(string2 + "pred");
        Resource resource4 = ResourceFactory.createResource(string2 + "obj");
        Literal literal7 = ResourceFactory.createPlainLiteral(string2 + "obj");
        Statement statement8 = ResourceFactory.createStatement(resource3, property, resource4);
        Statement statement9 = ResourceFactory.createStatement(resource3, property, literal7);
        Statement statement10 = ResourceFactory.createStatement(resource, property2, literal7);
        modelRDB.add(statement);
        modelRDB.add(statement2);
        modelRDB.add(statement3);
        modelRDB.add(statement4);
        modelRDB.add(statement5);
        modelRDB.add(statement6);
        modelRDB.add(statement7);
        modelRDB.add(statement8);
        modelRDB.add(statement9);
        modelRDB.add(statement10);
        Query query = new Query(this.pfxQueryString);
        query.setSource(modelRDB);
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults = queryEngine.exec();
        int n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 2 ? 1 : 0) != 0);
        query = new Query(this.ipfxQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 4 ? 1 : 0) != 0);
        query = new Query(this.sfxQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 1 ? 1 : 0) != 0);
        query = new Query(this.isfxQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 2 ? 1 : 0) != 0);
        query = new Query(this.epfxQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 1 ? 1 : 0) != 0);
        query = new Query(this.unboundQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 2 ? 1 : 0) != 0);
        query = new Query(this.lsubjQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 2 ? 1 : 0) != 0);
        query = new Query(this.lpredQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 1 ? 1 : 0) != 0);
        query = new Query(this.lobjQueryString);
        query.setSource(modelRDB);
        queryEngine = new QueryEngine(query);
        queryResults = queryEngine.exec();
        n = 0;
        while (queryResults.hasNext()) {
            queryResults.next();
            ++n;
        }
        TestRDQLMatch.assertTrue((n == 2 ? 1 : 0) != 0);
    }
}

