/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.PatternStage;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryPlan;
import com.hp.hpl.jena.graph.query.SimpleTreeQueryPlan;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Set;

public class SimpleQueryHandler
implements QueryHandler {
    protected Graph graph;

    public SimpleQueryHandler(Graph graph) {
        this.graph = graph;
    }

    public Stage patternStage(Mapping mapping, ExpressionSet expressionSet, Triple[] tripleArray) {
        return new PatternStage(this.graph, mapping, expressionSet, tripleArray);
    }

    public BindingQueryPlan prepareBindings(Query query, Node[] nodeArray) {
        return new SimpleQueryPlan(this.graph, query, nodeArray);
    }

    public TreeQueryPlan prepareTree(Graph graph) {
        return new SimpleTreeQueryPlan(this.graph, graph);
    }

    public ExtendedIterator objectsFor(Node node, Node node2) {
        return SimpleQueryHandler.objectsFor(this.graph, node, node2);
    }

    public ExtendedIterator subjectsFor(Node node, Node node2) {
        return SimpleQueryHandler.subjectsFor(this.graph, node, node2);
    }

    public ExtendedIterator predicatesFor(Node node, Node node2) {
        return SimpleQueryHandler.predicatesFor(this.graph, node, node2);
    }

    public static ExtendedIterator objectsFor(Graph graph, Node node, Node node2) {
        Set set = CollectionFactory.createHashedSet();
        ExtendedIterator extendedIterator = graph.find(node, node2, Node.ANY);
        while (extendedIterator.hasNext()) {
            set.add(((Triple)extendedIterator.next()).getObject());
        }
        return WrappedIterator.createNoRemove(set.iterator());
    }

    public static ExtendedIterator subjectsFor(Graph graph, Node node, Node node2) {
        Set set = CollectionFactory.createHashedSet();
        ExtendedIterator extendedIterator = graph.find(Node.ANY, node, node2);
        while (extendedIterator.hasNext()) {
            set.add(((Triple)extendedIterator.next()).getSubject());
        }
        return WrappedIterator.createNoRemove(set.iterator());
    }

    public static ExtendedIterator predicatesFor(Graph graph, Node node, Node node2) {
        Set set = CollectionFactory.createHashedSet();
        ExtendedIterator extendedIterator = graph.find(node, Node.ANY, node2);
        while (extendedIterator.hasNext()) {
            set.add(((Triple)extendedIterator.next()).getPredicate());
        }
        return WrappedIterator.createNoRemove(set.iterator());
    }

    public boolean containsNode(Node node) {
        return this.graph.contains(node, Node.ANY, Node.ANY) || this.graph.contains(Node.ANY, node, Node.ANY) || this.graph.contains(Node.ANY, Node.ANY, node);
    }
}

