/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HTTPRepositoryCreatorWizardPanel
extends RepositoryCreatorWizardPanel {
    private JTextField urlField;
    private WizardPage wizardPage;
    private static final String HELP_TEXT = "<p>Please specify a URL (http address) that points to the location on the web where the ontology can be downloaded from.</p>";

    public HTTPRepositoryCreatorWizardPanel(WizardPage wizardPage) {
        this.wizardPage = wizardPage;
        this.createUI();
    }

    private void createUI() {
        this.urlField = new JTextField();
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }

            public void removeUpdate(DocumentEvent e) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }

            public void changedUpdate(DocumentEvent e) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }
        });
        LabeledComponent lc = new LabeledComponent("URL (http:// address)", (Component)this.urlField);
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)lc, "North");
        this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, null, 160), "South");
        this.wizardPage.setPageComplete(this.validateData());
    }

    public Repository createRepository() {
        if (this.urlField.getText().length() > 0) {
            String errorMessage = null;
            try {
                URL url = new URL(this.urlField.getText());
                InputStream is = url.openStream();
                OntologyNameExtractor extractor = new OntologyNameExtractor(is, url);
                extractor.getOntologyName();
                is.close();
                if (extractor.isRDFRootElementPresent()) {
                    return new HTTPRepository(url);
                }
                errorMessage = "The document pointed to by " + url + " does not " + "appear to be a valid ontology.";
            }
            catch (MalformedURLException e) {
                errorMessage = "The URL " + this.urlField.getText() + " is malformed: " + e.getMessage();
            }
            catch (IOException ioEx) {
                errorMessage = "Could not obtain ontology from " + this.urlField.getText() + " due " + "to an IO error: " + ioEx.getMessage();
            }
            JOptionPane.showMessageDialog(this, errorMessage, "Error", 0);
            return null;
        }
        return null;
    }

    public boolean validateData() {
        if (this.urlField.getText().length() > 0) {
            try {
                URL url = new URL(this.urlField.getText());
                boolean b = url.getProtocol().equals("http") && url.getHost().length() > 0 && url.getPath().length() > 0;
                return b;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }
}

