/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ExportWizardPage;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ChangeProjectFormatWizardPage
extends ExportWizardPage {
    private Project project;
    private AbstractButton convertProjectButton;
    private BackendExportPlugin plugin;

    public ChangeProjectFormatWizardPage(ExportWizard exportWizard, BackendExportPlugin backendExportPlugin, Project project) {
        super("change project format", exportWizard);
        this.plugin = backendExportPlugin;
        this.project = project;
        AbstractButton abstractButton = this.createButton("Export Files and Leave Project Unchanged");
        abstractButton.setSelected(true);
        this.convertProjectButton = this.createButton("Convert Project to this Format");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(abstractButton);
        buttonGroup.add(this.convertProjectButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(abstractButton);
        this.add(this.convertProjectButton);
        this.setPageComplete(true);
    }

    private AbstractButton createButton(String string) {
        AbstractAction abstractAction = new AbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeProjectFormatWizardPage.this.updateNextPage();
            }
        };
        JRadioButton jRadioButton = ComponentFactory.createRadioButton(abstractAction);
        return jRadioButton;
    }

    public WizardPage getNextPage() {
        WizardPage wizardPage = this.convertProject() ? this.plugin.createExportToNewFormatWizardPage(this.getExportProjectWizard(), this.project) : this.plugin.createExportWizardPage(this.getExportProjectWizard(), this.project);
        return wizardPage;
    }

    public void onFinish() {
        ExportWizard exportWizard = (ExportWizard)this.getWizard();
        exportWizard.setExportToNewFormat(this.convertProject());
    }

    private boolean convertProject() {
        return this.convertProjectButton.isSelected();
    }
}

