/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;

public class MultiResourceListModel
extends AbstractListModel {
    private RDFProperty predicate;
    private RDFResource subject;
    private List values = new ArrayList();

    public MultiResourceListModel(RDFProperty predicate) {
        this.predicate = predicate;
    }

    public Object getElementAt(int index) {
        return this.values.get(index);
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    public RDFResource getResourceAt(int row) {
        return (RDFResource)this.getElementAt(row);
    }

    public int getRowOf(Object value) {
        return this.values.indexOf(value);
    }

    public int getSize() {
        return this.values.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public boolean isEditable(int row) {
        TripleStoreModel tsm = this.subject.getOWLModel().getTripleStoreModel();
        Object object = this.getElementAt(row);
        return tsm.isEditableTriple(this.subject, this.predicate, object);
    }

    public boolean isRDFResource(int row) {
        return this.getElementAt(row) instanceof RDFResource;
    }

    public void setSubject(RDFResource subject) {
        this.subject = subject;
        this.updateValues();
    }

    public void updateValues() {
        this.fireIntervalRemoved(this, 0, this.values.size());
        this.values = new ArrayList(this.subject.getPropertyValues(this.predicate, true));
        Collection hasValues = this.subject.getHasValuesOnTypes(this.predicate);
        for (Object value : hasValues) {
            if (!(value instanceof RDFResource) || this.values.contains(value)) continue;
            this.values.add(value);
        }
        this.fireIntervalAdded(this, 0, this.values.size());
    }
}

