/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPRunnable;
import com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.PushMePullYouPipe;
import com.hp.hpl.jena.rdf.arp.RDFParser;
import com.hp.hpl.jena.rdf.arp.XMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class SAX2RDFImpl
extends XMLHandler
implements LexicalHandler,
ContentHandler,
ErrorHandler {
    private int depth;
    private ARPRunnable rdf;
    private final String lang;

    SAX2RDFImpl(String string, String string2) {
        this.lang = string2;
    }

    protected void initParse(String string) throws MalformedURIException {
        super.initParse(string);
        if (this.lang != null && !this.lang.equals("")) {
            this.documentContext = this.documentContext.withLang(this.lang);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.depth > 0) {
            super.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.depth > 0) {
            super.endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        if (this.depth > 0) {
            super.startCDATA();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXParseException {
        if (this.depth > 0) {
            super.comment(cArray, n, n2);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.depth > 0) {
            super.endEntity(string);
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.depth > 0) {
            super.startEntity(string);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.depth > 0) {
            super.startDTD(string, string2, string3);
        }
    }

    public void endDocument() throws SAXException {
        if (this.depth > 0) {
            super.endDocument();
        }
    }

    public void startDocument() throws SAXException {
        if (this.depth > 0) {
            super.startDocument();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            super.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void endPrefixMapping(String string) {
        if (this.depth > 0) {
            super.endPrefixMapping(string);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.depth > 0) {
            super.skippedEntity(string);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.depth > 0) {
            super.processingInstruction(string, string2);
        }
    }

    public void startPrefixMapping(String string, String string2) {
        super.startPrefixMapping(string, string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.depth <= 0) {
            this.fatalError(new SAXParseException("Unmatched end tag: " + string3, this.getLocator()));
        }
        super.endElement(string, string2, string3);
        if (--this.depth == 0) {
            this.close();
        }
    }

    void close() throws SAXException {
        if (this.pipe() != null) {
            this.pipe().close();
            if (!this.pipe().exactlyExhausted()) {
                this.getHandlers().getErrorHandler().error(new SAXParseException("Too many XML events for RDF grammar; error condition not thought through, please report on jena-dev.", this.getLocator()));
            }
        }
        this.endBnodeScope();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.depth++ == 0) {
            this.rdf = new ARPRunnable(){

                public void run() throws ParseException {
                    RDFParser rDFParser = new RDFParser(SAX2RDFImpl.this.pipe, SAX2RDFImpl.this);
                    if (SAX2RDFImpl.this.getOptions().getEmbedding()) {
                        rDFParser.embeddedFile(SAX2RDFImpl.this.documentContext);
                    } else {
                        rDFParser.rdfFile(SAX2RDFImpl.this.documentContext);
                    }
                }
            };
            this.pipe = new PushMePullYouPipe(this.rdf);
            ((PushMePullYouPipe)this.pipe).start();
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        if (this.depth > 0) {
            super.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.depth > 0) {
            try {
                super.fatalError(sAXParseException);
            }
            catch (FatalParsingErrorException fatalParsingErrorException) {
                this.pipe().close();
                throw sAXParseException;
            }
        }
    }

    private PushMePullYouPipe pipe() {
        return (PushMePullYouPipe)this.pipe;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        if (this.depth > 0) {
            super.warning(sAXParseException);
        }
    }
}

