/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.util.List;

/**
 * This class represents a single search result.
 * 
 * @author tilmann
 */
public class ServiceInfo implements Comparable<ServiceInfo> {

    private ServiceInstanceInfo instanceInfo;

    private ServiceProfileInfo profileInfo;

    public ServiceInfo(ServiceProfileInfo profileInfo,
            ServiceInstanceInfo instanceInfo) {
        this.profileInfo = profileInfo;
        this.instanceInfo = instanceInfo;
    }

    /**
     * @return Returns the wsdlLocation.
     */
    public String getWsdlLocation() {
        return instanceInfo.getWsdlLocation();
    }

    /**
     * @param wsdlLocation
     *            The wsdlLocation to set.
     */
    public void setWsdlLocation(String wsdlLocation) {
        instanceInfo.setWsdlLocation(wsdlLocation);
    }

    /**
     * @return Returns the relevance.
     */
    public double getRelevance() {
        return profileInfo.getRelevance();
    }

    /**
     * @param relevance
     *            The relevance to set.
     */
    public void setRelevance(double relevance) {
        profileInfo.setRelevance(relevance);
    }

    /**
     * @return Returns the businessName.
     */
    public String getBusinessName() {
        return instanceInfo.getBusinessName();
    }

    /**
     * @param businessName
     *            The businessName to set.
     */
    public void setBusinessName(String businessName) {
        instanceInfo.setBusinessName(businessName);
    }

    /**
     * @return Returns the profileUri.
     */
    public String getProfileUri() {
        return instanceInfo.getProfileUri();
    }

    /**
     * @param profileUri
     *            The profileUri to set.
     */
    public void setProfileUri(String profileUri) {
        instanceInfo.setProfileUri(profileUri);
    }

    /**
     * @return Returns the effects.
     */
    public List<String> getEffects() {
        return profileInfo.getEffects();
    }

    /**
     * @return Returns the effects as comma seperated list.
     */
    public String getEffectsCsv() {
        return profileInfo.getEffectsCsv();
    }

    /**
     * @param effects
     *            The effects to set.
     */
    public void setEffects(List<String> effects) {
        profileInfo.setEffects(effects);
    }

    /**
     * @param effects
     *            The effects to set as comma seperated list.
     */
    public void setEffectsCsv(String effects) {
        profileInfo.setEffectsCsv(effects);
    }

    /**
     * @return Returns the logicalInputs.
     */
    public List<String> getLogicalInputs() {
        return profileInfo.getLogicalInputs();
    }

    /**
     * @return Returns the logicalInputs as comma seperated list.
     */
    public String getLogicalInputsCsv() {
        return profileInfo.getLogicalInputsCsv();
    }

    /**
     * @param logicalInputs
     *            The logicalInputs to set.
     */
    public void setLogicalInputs(List<String> logicalInputs) {
        profileInfo.setLogicalInputs(logicalInputs);
    }

    /**
     * @param logicalInputs
     *            The logicalInputs to set as comma seperated list.
     */
    public void setLogicalInputsCsv(String logicalInputs) {
        profileInfo.setLogicalInputsCsv(logicalInputs);
    }

    /**
     * @return Returns the logicalOutputs.
     */
    public List<String> getLogicalOutputs() {
        return profileInfo.getLogicalOutputs();
    }

    /**
     * @return Returns the logicalOutputs as comma seperated list.
     */
    public String getLogicalOutputsCsv() {
        return profileInfo.getLogicalOutputsCsv();
    }

    /**
     * @param logicalOutputs
     *            The logicalOutputs to set.
     */
    public void setLogicalOutputs(List<String> logicalOutputs) {
        profileInfo.setLogicalOutputs(logicalOutputs);
    }

    /**
     * @param logicalOutputs
     *            The logicalOutputs to set as comma seperated list.
     */
    public void setLogicalOutputsCsv(String logicalOutputs) {
        profileInfo.setLogicalOutputsCsv(logicalOutputs);
    }

    /**
     * @return Returns the preconditions.
     */
    public List<String> getPreconditions() {
        return profileInfo.getPreconditions();
    }

    /**
     * @return Returns the preconditions as comma seperated list.
     */
    public String getPreconditionsCsv() {
        return profileInfo.getPreconditionsCsv();
    }

    /**
     * @param preconditions
     *            The preconditions to set.
     */
    public void setPreconditions(List<String> preconditions) {
        profileInfo.setPreconditions(preconditions);
    }

    /**
     * @param preconditions
     *            The preconditions to set as comma seperated list.
     */
    public void setPreconditionsCsv(String preconditions) {
        profileInfo.setPreconditionsCsv(preconditions);
    }

    /**
     * @return Returns the category.
     */
    public String getCategory() {
        return profileInfo.getCategory();
    }

    /**
     * @param category
     *            The category to set.
     */
    public void setCategory(String category) {
        profileInfo.setCategory(category);
    }

    /**
     * @return Returns the userRoles as comma seperated list.
     */
    public String getUserRolesCsv() {
        return profileInfo.getUserRolesCsv();
    }

    /**
     * @param userRoles
     *            The userRoles to set as comma seperated list.
     */
    public void setUserRolesCsv(String userRoles) {
        profileInfo.setUserRolesCsv(userRoles);
    }
    
    /**
     * @return Returns the userRoles.
     */
    public List<String> getUserRoles() {
        return profileInfo.getUserRoles();
    }

    /**
     * @param userRoles
     *            The userRoles to set.
     */
    public void setUserRoles(List<String> userRoles) {
        profileInfo.setUserRoles(userRoles);
    }
    
	/**
	 * @return the description
	 */
	public String getDescription() {
		return profileInfo.getDescription();
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		profileInfo.setDescription(description);
	}

    @Override
    public String toString() {
        return profileInfo.toString() + instanceInfo.toString();
    }
    
	public int compareTo(ServiceInfo o) {
		if (profileInfo.getRelevance() > o.getRelevance()) return -1;
		if (profileInfo.getRelevance() < o.getRelevance()) return 1;
		return 0;
	}
}
