/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

/**
 * This class represents search parameters used during the search for service
 * instance.
 * 
 * @author tilmann
 * 
 */
public class ServiceInstanceParameter implements Cloneable {

	private String businessName;

	private String profileUri;

	/**
	 * @return Returns the businessName.
	 */
	public String getBusinessName() {
		return businessName;
	}

	/**
	 * @param businessName
	 *            The businessName to set.
	 */
	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	/**
	 * @return Returns the profileUri.
	 */
	public String getProfileUri() {
		return profileUri;
	}

	/**
	 * @param profileUri
	 *            The profileUri to set.
	 */
	public void setProfileUri(String profileUri) {
		this.profileUri = profileUri;
	}

	@Override
	public String toString() {
		return "ProfileUri: " + profileUri + "\nBusinessName: "
				+ businessName + "\n";
	}

	@Override
	public ServiceInstanceParameter clone() {
		try {
			return (ServiceInstanceParameter) super.clone();
		} catch (CloneNotSupportedException e) {

			// This should not happen
			e.printStackTrace();
		}
		return null;
	}

}
