/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

/**
 * This class can be used to create ServiceLocators.
 * 
 * @author tilmann
 */
public class ServiceLocatorFactory {

	private String uddiInquiryUrl;

	private String digReasonerUrl;

	private String serviceOntologyUrl;

	private String upperServiceOntologyUrl;

	private String topOntologyUrl;

	/**
	 * Creates a new DefaultServiceLocator.
	 * 
	 * @return the newly created ServiceLocator
	 * @throws InstantiationException
	 */
	public ServiceLocator createServiceLocator() throws InstantiationException {
		if (uddiInquiryUrl == null)
			throw new IllegalStateException(
					"UddiInquiryUrl must be set prior to a call to createServiceLocator.");
		if (serviceOntologyUrl == null)
			throw new IllegalStateException(
					"ServiceOntologyUrl must be set prior to a call to createServiceLocator.");
		if (upperServiceOntologyUrl == null)
			throw new IllegalStateException(
					"UpperServiceOntologyUrl must be set prior to a call to createServiceLocator.");
		if (topOntologyUrl == null)
			throw new IllegalStateException(
					"TopOntologyUrl must be set prior to a call to createServiceLocator.");
		if (digReasonerUrl == null)
			throw new IllegalStateException(
					"DigReasoneryUrl must be set prior to a call to createServiceLocator.");

		return new DefaultServiceLocator(uddiInquiryUrl, digReasonerUrl,
				serviceOntologyUrl, upperServiceOntologyUrl, topOntologyUrl);
	}

	/**
	 * @return the serviceOntologyUrl
	 */
	public String getServiceOntologyUrl() {
		return serviceOntologyUrl;
	}

	/**
	 * @param serviceOntologyUrl
	 *            the serviceOntologyUrl to set
	 */
	public void setServiceOntologyUrl(String serviceOntologyUrl) {
		this.serviceOntologyUrl = serviceOntologyUrl;
	}

	/**
	 * @return the topOntologyUrl
	 */
	public String getTopOntologyUrl() {
		return topOntologyUrl;
	}

	/**
	 * @param topOntologyUrl
	 *            the topOntologyUrl to set
	 */
	public void setTopOntologyUrl(String topOntologyUrl) {
		this.topOntologyUrl = topOntologyUrl;
	}

	/**
	 * @return the uddiInquiryUrl
	 */
	public String getUddiInquiryUrl() {
		return uddiInquiryUrl;
	}

	/**
	 * @param uddiInquiryUrl
	 *            the uddiInquiryUrl to set
	 */
	public void setUddiInquiryUrl(String uddiInquiryUrl) {
		this.uddiInquiryUrl = uddiInquiryUrl;
	}

	/**
	 * @return the upperServiceOntologyUrl
	 */
	public String getUpperServiceOntologyUrl() {
		return upperServiceOntologyUrl;
	}

	/**
	 * @param upperServiceOntologyUrl
	 *            the upperServiceOntologyUrl to set
	 */
	public void setUpperServiceOntologyUrl(String upperServiceOntologyUrl) {
		this.upperServiceOntologyUrl = upperServiceOntologyUrl;
	}

	/**
	 * @return the digReasonerUrl
	 */
	public String getDigReasonerUrl() {
		return digReasonerUrl;
	}

	/**
	 * @param digReasonerUrl the digReasonerUrl to set
	 */
	public void setDigReasonerUrl(String digReasonerUrl) {
		this.digReasonerUrl = digReasonerUrl;
	}

}
