/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.util.List;

/**
 * This class holds the query parameters used by ServiceLocator.
 * 
 * @author tilmann
 */
public class ServiceParameter {

	/**
	 * Nested instance used to hold the values.
	 */
    private ServiceInstanceParameter instanceParameter = new ServiceInstanceParameter();

    /**
	 * Nested instance used to hold the values.
	 */
    private ServiceProfileParameter profileParameter = new ServiceProfileParameter();

    /**
     * @return Returns the businessName.
     */
    public String getBusinessName() {
        return instanceParameter.getBusinessName();
    }

    /**
     * @param businessName
     *            The businessName to set.
     */
    public void setBusinessName(String businessName) {
        instanceParameter.setBusinessName(businessName);
    }

    /**
     * @return Returns the effects.
     */
    public List<String> getEffects() {
        return profileParameter.getEffects();
    }

    /**
     * @return Returns the effects as comma seperated list.
     */
    public String getEffectsCsv() {
        return profileParameter.getEffectsCsv();
    }

    /**
     * @param effects
     *            The effects to set.
     */
    public void setEffects(List<String> effects) {
        profileParameter.setEffects(effects);
    }

    /**
     * @param effects
     *            The effects to set as comma seperated list.
     */
    public void setEffectsCsv(String effects) {
        profileParameter.setEffectsCsv(effects);
    }

    /**
     * @return Returns the logicalInputs.
     */
    public List<String> getLogicalInputs() {
        return profileParameter.getLogicalInputs();
    }

    /**
     * @return Returns the logicalInputs as comma seperated list.
     */
    public String getLogicalInputsCsv() {
        return profileParameter.getLogicalInputsCsv();
    }

    /**
     * @param logicalInputs
     *            The logicalInputs to set.
     */
    public void setLogicalInputs(List<String> logicalInputs) {
        profileParameter.setLogicalInputs(logicalInputs);
    }

    /**
     * @param logicalInputs
     *            The logicalInputs to set as comma seperated list.
     */
    public void setLogicalInputsCsv(String logicalInputs) {
        profileParameter.setLogicalInputsCsv(logicalInputs);
    }

    /**
     * @return Returns the logicalOutputs.
     */
    public List<String> getLogicalOutputs() {
        return profileParameter.getLogicalOutputs();
    }

    /**
     * @return Returns the logicalOutputs as comma seperated list.
     */
    public String getLogicalOutputsCsv() {
        return profileParameter.getLogicalOutputsCsv();
    }

    /**
     * @param logicalOutputs
     *            The logicalOutputs to set.
     */
    public void setLogicalOutputs(List<String> logicalOutputs) {
        profileParameter.setLogicalOutputs(logicalOutputs);
    }

    /**
     * @param logicalOutputs
     *            The logicalOutputs to set as comma seperated list.
     */
    public void setLogicalOutputsCsv(String logicalOutputs) {
        profileParameter.setLogicalOutputsCsv(logicalOutputs);
    }

    /**
     * @return Returns the preconditions.
     */
    public List<String> getPreconditions() {
        return profileParameter.getPreconditions();
    }

    /**
     * @return Returns the preconditions as comma seperated list.
     */
    public String getPreconditionsCsv() {
        return profileParameter.getPreconditionsCsv();
    }

    /**
     * @param preconditions
     *            The preconditions to set.
     */
    public void setPreconditions(List<String> preconditions) {
        profileParameter.setPreconditions(preconditions);
    }

    /**
     * @param preconditions
     *            The preconditions to set as comma seperated list.
     */
    public void setPreconditionsCsv(String preconditions) {
        profileParameter.setPreconditionsCsv(preconditions);
    }

    /**
     * @return Returns the category.
     */
    public String getCategory() {
        return profileParameter.getCategory();
    }

    /**
     * @param category
     *            The category to set.
     */
    public void setCategory(String category) {
        profileParameter.setCategory(category);
    }

    /**
     * @return Returns the userRoles as comma seperated values.
     */
    public String getUserRolesCsv() {
        return profileParameter.getUserRolesCsv();
    }
    
    /**
     * @return Returns the userRoles.
     */
    public List<String> getUserRoles() {
        return profileParameter.getUserRoles();
    }

    /**
     * @param userRoles
     *            The userRoles to set as comma sepreated values.
     */
    public void setUserRolesCsv(String userRoles) {
        profileParameter.setUserRolesCsv(userRoles);
    }
    
    /**
     * @param userRoles
     *            The userRoles to set.
     */
    public void setUserRoles(List<String> userRoles) {
        profileParameter.setUserRoles(userRoles);
    }
    
    @Override
    public String toString() {
        return profileParameter.toString() + instanceParameter.toString();
    }

    /**
     * @return Returns the instanceParameter.
     */
    ServiceInstanceParameter getInstanceParameter() {
        return instanceParameter;
    }

    /**
     * @return Returns the profileParameter.
     */
    ServiceProfileParameter getProfileParameter() {
        return profileParameter;
    }

}
