/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableCellHolder;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class AnnotationsValueRenderer
implements TableCellRenderer {
    private JTextArea textArea = new JTextArea();
    private JLabel label;
    private JLabel langLabel;
    public static final int EXTRA_SPACING = 4;
    private AnnotationsTableCellHolder resourceHolder;
    private AnnotationsTableCellHolder plainTextPropertyValHolder;
    private AnnotationsTableCellHolder langHolder;

    public AnnotationsValueRenderer() {
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setFocusable(true);
        this.textArea.setOpaque(false);
        this.plainTextPropertyValHolder = new AnnotationsTableCellHolder(this.textArea, "Center");
        this.label = new JLabel();
        this.label.setOpaque(false);
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            this.label.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        }
        this.resourceHolder = new AnnotationsTableCellHolder(this.label, "North");
        this.langLabel = new JLabel();
        this.langHolder = new AnnotationsTableCellHolder(this.langLabel, "North");
    }

    public Component getTableCellRendererComponent(JTable table, Object o, boolean selected, boolean hasFocus, int row, int col) {
        if (table.getEditingRow() != row || table.getEditingColumn() != 1) {
            int rowHeight = this.getRowHeight(table, row);
            if (table.getRowHeight(row) != rowHeight) {
                table.setRowHeight(row, rowHeight);
            }
        }
        if (col == 0) {
            return this.getResourceComponent((RDFResource)o, selected, hasFocus);
        }
        if (col == 1) {
            if (o instanceof RDFResource) {
                return this.getResourceComponent((RDFResource)o, selected, hasFocus);
            }
            this.textArea.setText(o != null ? o.toString() : "");
            this.plainTextPropertyValHolder.setColors(selected, hasFocus);
            return this.plainTextPropertyValHolder;
        }
        this.langLabel.setText(o != null ? o.toString() : "");
        this.langHolder.setColors(selected, hasFocus);
        return this.langHolder;
    }

    private JComponent getResourceComponent(RDFResource resource, boolean selected, boolean focused) {
        this.label.setText(resource.getBrowserText());
        this.label.setIcon(ProtegeUI.getIcon(resource));
        this.resourceHolder.setColors(selected, focused);
        return this.resourceHolder;
    }

    private int getRowHeight(JTable table, int row) {
        Object val = table.getValueAt(row, 1);
        if (val instanceof String) {
            String text = val.toString();
            this.textArea.setText(text);
            View v = this.textArea.getUI().getRootView(this.textArea);
            v.setSize(table.getColumnModel().getColumn(1).getWidth(), 2.1474836E9f);
            int height = (int)v.getPreferredSpan(1) + 4;
            if (height < table.getRowHeight()) {
                height = table.getRowHeight();
            }
            return height;
        }
        return table.getRowHeight();
    }
}

