/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DBBulkUpdateHandler
implements BulkUpdateHandler {
    private GraphRDB graph;
    private GraphEventManager manager;
    protected static int CHUNK_SIZE = 50;

    public DBBulkUpdateHandler(GraphRDB graphRDB) {
        this.graph = graphRDB;
        this.manager = graphRDB.getEventManager();
    }

    public void add(Triple[] tripleArray) {
        this.add(Arrays.asList(tripleArray), false);
        this.manager.notifyAddArray(this.graph, tripleArray);
    }

    public void add(List list) {
        this.add(list, true);
    }

    protected void add(List list, boolean bl) {
        this.graph.add(list);
        if (bl) {
            this.manager.notifyAddList(this.graph, list);
        }
    }

    public void add(Iterator iterator) {
        if (this.manager.listening()) {
            List list = IteratorCollection.iteratorToList(iterator);
            this.add(list, false);
            this.manager.notifyAddIterator((Graph)this.graph, list);
        } else {
            this.addIterator(iterator);
        }
    }

    protected void addIterator(Iterator iterator) {
        ArrayList arrayList = new ArrayList(CHUNK_SIZE);
        while (iterator.hasNext()) {
            while (iterator.hasNext() && arrayList.size() < CHUNK_SIZE) {
                arrayList.add(iterator.next());
            }
            this.graph.add(arrayList);
            arrayList.clear();
        }
    }

    public void add(Graph graph) {
        this.add(graph, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graph graph, boolean bl) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        try {
            this.addIterator(extendedIterator);
        }
        finally {
            extendedIterator.close();
        }
        if (bl) {
            SimpleBulkUpdateHandler.addReifications(this.graph, graph);
        }
        this.manager.notifyAddGraph(this.graph, graph);
    }

    public void delete(Triple[] tripleArray) {
        this.delete(Arrays.asList(tripleArray), false);
        this.manager.notifyDeleteArray(this.graph, tripleArray);
    }

    public void delete(List list) {
        this.delete(list, true);
    }

    protected void delete(List list, boolean bl) {
        this.graph.delete(list);
        if (bl) {
            this.manager.notifyDeleteList(this.graph, list);
        }
    }

    public void delete(Iterator iterator) {
        if (this.manager.listening()) {
            List list = IteratorCollection.iteratorToList(iterator);
            this.delete(list, false);
            this.manager.notifyDeleteIterator((Graph)this.graph, list);
        } else {
            this.deleteIterator(iterator);
        }
    }

    protected void deleteIterator(Iterator iterator) {
        ArrayList arrayList = new ArrayList(CHUNK_SIZE);
        while (iterator.hasNext()) {
            while (iterator.hasNext() && arrayList.size() < CHUNK_SIZE) {
                arrayList.add(iterator.next());
            }
            this.graph.delete(arrayList);
            arrayList.clear();
        }
    }

    public void delete(Graph graph) {
        this.delete(graph, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Graph graph, boolean bl) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        try {
            this.deleteIterator(extendedIterator);
        }
        finally {
            extendedIterator.close();
        }
        if (bl) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, graph);
        }
        this.manager.notifyDeleteGraph(this.graph, graph);
    }

    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node node, Node node2, Node node3) {
        SimpleBulkUpdateHandler.removeAll(this.graph, node, node2, node3);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(node, node2, node3));
    }
}

