/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.IntLiteralAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl;
import com.hp.hpl.jena.ontology.daml.impl.IntLiteralAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.vocabulary.DAML_OIL;

public class DAMLRestrictionImpl
extends DAMLClassImpl
implements DAMLRestriction {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLRestrictionImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLRestriction");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return DAMLRestrictionImpl.hasType(node, enhGraph, DAML_OIL.Restriction);
        }
    };
    private PropertyAccessor m_propOnProperty = new PropertyAccessorImpl(this.getVocabulary().onProperty(), this);
    private PropertyAccessor m_propHasClass = new PropertyAccessorImpl(this.getVocabulary().hasClass(), this);
    private PropertyAccessor m_propToClass = new PropertyAccessorImpl(this.getVocabulary().toClass(), this);
    private PropertyAccessor m_propHasValue = new PropertyAccessorImpl(this.getVocabulary().hasValue(), this);
    private PropertyAccessor m_propHasClassQ = new PropertyAccessorImpl(this.getVocabulary().hasClassQ(), this);
    private IntLiteralAccessor m_propCardinality = new IntLiteralAccessorImpl(this.getVocabulary().cardinality(), this);
    private IntLiteralAccessor m_propMinCardinality = new IntLiteralAccessorImpl(this.getVocabulary().minCardinality(), this);
    private IntLiteralAccessor m_propMaxCardinality = new IntLiteralAccessorImpl(this.getVocabulary().maxCardinality(), this);
    private IntLiteralAccessor m_propCardinalityQ = new IntLiteralAccessorImpl(this.getVocabulary().cardinalityQ(), this);
    private IntLiteralAccessor m_propMinCardinalityQ = new IntLiteralAccessorImpl(this.getVocabulary().minCardinalityQ(), this);
    private IntLiteralAccessor m_propMaxCardinalityQ = new IntLiteralAccessorImpl(this.getVocabulary().maxCardinalityQ(), this);

    public DAMLRestrictionImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public boolean isRestriction() {
        return true;
    }

    public PropertyAccessor prop_onProperty() {
        return this.m_propOnProperty;
    }

    public PropertyAccessor prop_toClass() {
        return this.m_propToClass;
    }

    public PropertyAccessor prop_hasValue() {
        return this.m_propHasValue;
    }

    public PropertyAccessor prop_hasClass() {
        return this.m_propHasClass;
    }

    public IntLiteralAccessor prop_cardinality() {
        return this.m_propCardinality;
    }

    public IntLiteralAccessor prop_minCardinality() {
        return this.m_propMinCardinality;
    }

    public IntLiteralAccessor prop_maxCardinality() {
        return this.m_propMaxCardinality;
    }

    public PropertyAccessor prop_hasClassQ() {
        return this.m_propHasClassQ;
    }

    public IntLiteralAccessor prop_cardinalityQ() {
        return this.m_propCardinalityQ;
    }

    public IntLiteralAccessor prop_minCardinalityQ() {
        return this.m_propMinCardinalityQ;
    }

    public IntLiteralAccessor prop_maxCardinalityQ() {
        return this.m_propMaxCardinalityQ;
    }
}

