/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;

public class BindingVector
implements BindingEnvironment {
    protected Node[] environment;

    public BindingVector() {
        this.environment = new Node[10];
    }

    public BindingVector(Node[] nodeArray) {
        this.environment = nodeArray;
    }

    public BindingVector(BindingVector bindingVector) {
        Node[] nodeArray = bindingVector.environment;
        this.environment = new Node[nodeArray.length];
        System.arraycopy(nodeArray, 0, this.environment, 0, nodeArray.length);
    }

    public Node[] getEnvironment() {
        return this.environment;
    }

    public Node getBinding(Node node) {
        if (node instanceof Node_RuleVariable) {
            Node node2 = this.environment[((Node_RuleVariable)node).getIndex()];
            if (node2 instanceof Node_RuleVariable) {
                return this.getBinding(node2);
            }
            return node2;
        }
        if (node instanceof Node_ANY) {
            return null;
        }
        if (Functor.isFunctor(node)) {
            Functor functor = (Functor)node.getLiteral().getValue();
            if (functor.isGround()) {
                return node;
            }
            Node[] nodeArray = functor.getArgs();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node3 = this.getBinding(nodeArray[i]);
                if (node3 == null) {
                    return null;
                }
                arrayList.add(node3);
            }
            Functor functor2 = new Functor(functor.getName(), arrayList);
            return Functor.makeFunctorNode(functor2);
        }
        return node;
    }

    public Node getGroundVersion(Node node) {
        Node node2 = this.getBinding(node);
        if (node2 == null) {
            return node;
        }
        return node2;
    }

    public boolean bind(int n, Node node) {
        Node node2 = this.environment[n];
        if (node2 == null) {
            this.environment[n] = node;
            return true;
        }
        if (node2 instanceof Node_RuleVariable) {
            this.environment[n] = node;
            return this.bind(((Node_RuleVariable)node2).getIndex(), node);
        }
        return node2.sameValueAs(node);
    }

    public boolean bind(Node node, Node node2) {
        if (node instanceof Node_RuleVariable) {
            return this.bind(((Node_RuleVariable)node).getIndex(), node2);
        }
        return node.sameValueAs(node2);
    }

    public TriplePattern partInstantiate(TriplePattern triplePattern) {
        return new TriplePattern(this.getGroundVersion(triplePattern.getSubject()), this.getGroundVersion(triplePattern.getPredicate()), this.getGroundVersion(triplePattern.getObject()));
    }

    public Triple instantiate(TriplePattern triplePattern) {
        Node node;
        Node node2;
        Node node3 = this.getGroundVersion(triplePattern.getSubject());
        if (node3.isVariable()) {
            node3 = Node.createAnon();
        }
        if ((node2 = this.getGroundVersion(triplePattern.getPredicate())).isVariable()) {
            node2 = Node.createAnon();
        }
        if ((node = this.getGroundVersion(triplePattern.getObject())).isVariable()) {
            node = Node.createAnon();
        }
        return new Triple(node3, node2, node);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.environment.length; ++i) {
            if (this.environment[i] == null) {
                stringBuffer.append("-");
            } else {
                stringBuffer.append(PrintUtil.print(this.environment[i]));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static BindingVector unify(TriplePattern triplePattern, TriplePattern triplePattern2) {
        return BindingVector.unify(triplePattern, triplePattern2, 10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BindingVector unify(TriplePattern triplePattern, TriplePattern triplePattern2, int n) {
        Node[] nodeArray;
        Node[] nodeArray2;
        Node[] nodeArray3;
        Node[] nodeArray4;
        block11: {
            Node node;
            Node node2;
            block10: {
                nodeArray4 = new Node[10];
                nodeArray3 = new Node[n];
                if (!BindingVector.unify(triplePattern.getSubject(), triplePattern2.getSubject(), nodeArray4, nodeArray3)) {
                    return null;
                }
                if (!BindingVector.unify(triplePattern.getPredicate(), triplePattern2.getPredicate(), nodeArray4, nodeArray3)) {
                    return null;
                }
                node2 = triplePattern.getObject();
                node = triplePattern2.getObject();
                if (!Functor.isFunctor(node2)) break block10;
                Functor functor = (Functor)node2.getLiteral().getValue();
                if (Functor.isFunctor(node)) {
                    Functor functor2 = (Functor)node.getLiteral().getValue();
                    if (!functor.getName().equals(functor2.getName())) {
                        return null;
                    }
                    nodeArray2 = functor.getArgs();
                    if (nodeArray2.length != (nodeArray = functor2.getArgs()).length) {
                        return null;
                    }
                    break block11;
                } else {
                    if (!(node instanceof Node_RuleVariable)) {
                        return null;
                    }
                    if (!functor.isGround(new BindingVector(nodeArray4)) || BindingVector.unify(node2, node, nodeArray4, nodeArray3)) return new BindingVector(nodeArray3);
                    return null;
                }
            }
            if (BindingVector.unify(node2, node, nodeArray4, nodeArray3)) return new BindingVector(nodeArray3);
            return null;
        }
        for (int i = 0; i < nodeArray2.length; ++i) {
            if (BindingVector.unify(nodeArray2[i], nodeArray[i], nodeArray4, nodeArray3)) continue;
            return null;
        }
        return new BindingVector(nodeArray3);
    }

    private static boolean unify(Node node, Node node2, Node[] nodeArray, Node[] nodeArray2) {
        if (node2 instanceof Node_RuleVariable) {
            int n = ((Node_RuleVariable)node2).getIndex();
            if (node instanceof Node_RuleVariable) {
                int n2 = ((Node_RuleVariable)node).getIndex();
                if (n2 < 0) {
                    return true;
                }
                if (nodeArray[n2] == null) {
                    nodeArray[n2] = node2;
                } else {
                    Node node3 = nodeArray[n2];
                    if (n != n2 || !(node3 instanceof Node_RuleVariable)) {
                        nodeArray2[n] = node3;
                    }
                }
            } else {
                Node node4 = nodeArray2[n];
                if (node4 == null) {
                    nodeArray2[n] = node;
                } else if (node4 instanceof Node_RuleVariable) {
                    nodeArray2[((Node_RuleVariable)node4).getIndex()] = node;
                    nodeArray2[n] = node;
                } else {
                    return node4.sameValueAs(node);
                }
            }
            return true;
        }
        if (node instanceof Node_RuleVariable) {
            int n = ((Node_RuleVariable)node).getIndex();
            if (n < 0) {
                return true;
            }
            Node node5 = nodeArray[n];
            if (node5 == null) {
                nodeArray[n] = node2;
            } else if (node5 instanceof Node_RuleVariable) {
                nodeArray2[((Node_RuleVariable)node5).getIndex()] = node2;
                nodeArray[n] = node2;
            } else {
                return node5.sameValueAs(node2);
            }
            return true;
        }
        return node2.sameValueAs(node);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BindingVector)) {
            return false;
        }
        Node[] nodeArray = ((BindingVector)object).environment;
        if (this.environment.length != nodeArray.length) {
            return false;
        }
        for (int i = 0; i < this.environment.length; ++i) {
            Node node = this.environment[i];
            Node node2 = nodeArray[i];
            if (!(node == null ? node2 != null : !node.sameValueAs(node2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.environment.length; ++i) {
            Node node = this.environment[i];
            n = n << 1 ^ (node == null ? 21372 : node.hashCode());
        }
        return n;
    }
}

