/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.SplashScreen;
import edu.stanford.smi.protege.ui.WelcomeDialog;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Application {
    private static transient Logger log = Log.getLogger(Application.class);
    private static JFrame _mainFrame;
    private static SplashScreen _splashScreen;
    private static WelcomeDialog _welcome;
    private static final String projectFileExtension = ".pprj";

    private static void initialize() {
        try {
            SystemUtilities.initialize();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", exception);
        }
    }

    public static Component getMainWindow() {
        Window window = _splashScreen != null ? _splashScreen : _mainFrame;
        return window;
    }

    private static URI getProjectURI(String[] stringArray) {
        URI uRI = null;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            if (!string.endsWith(projectFileExtension)) {
                string = string + projectFileExtension;
            }
            uRI = URIUtilities.createURI(string);
        }
        return uRI;
    }

    private static void init(String[] stringArray) {
        Object object;
        int n;
        Application.parseOptions(stringArray);
        _mainFrame = ComponentFactory.createMainFrame();
        _mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjectManager.getProjectManager().exitApplicationRequest();
            }
        });
        Application.restoreMainframeRectangle();
        ProjectManager.getProjectManager().setRootPane(_mainFrame.getRootPane());
        Project project = null;
        if (stringArray.length > 0 && (n = ((String)(object = stringArray[0])).lastIndexOf(46)) > 0 && n < ((String)object).length() - 1 && new File((String)object).exists() && !((String)object).endsWith(projectFileExtension)) {
            String string = ((String)object).substring(n + 1);
            Iterator iterator = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames().iterator();
            while (iterator.hasNext() && project == null) {
                Class clazz = (Class)iterator.next();
                project = Application.useCreateProjectFromFilePlugin(clazz, string, (String)object);
                if (project == null) continue;
                String string2 = ((String)object).substring(0, n) + projectFileExtension;
                project.setProjectFilePath(string2);
                ProjectManager.getProjectManager().setCurrentProject(project, false);
            }
        }
        if (project != null) {
            Application.showMainFrame();
        } else {
            object = Application.getProjectURI(stringArray);
            if (object != null) {
                ProjectManager.getProjectManager().loadProject((URI)object);
                Application.showMainFrame();
            } else {
                Application.showMainFrame();
                n = ApplicationProperties.getWelcomeDialogShow() ? 1 : 0;
                if (n != 0) {
                    _welcome = new WelcomeDialog(_mainFrame, "Welcome to " + Text.getProgramName(), true);
                    _welcome.setSize(new Dimension(600, 350));
                    _welcome.setLocationRelativeTo(_mainFrame);
                    _welcome.setVisible(true);
                }
            }
        }
    }

    public static Project useCreateProjectFromFilePlugin(Class clazz, String string, String string2) {
        if (clazz != null) {
            try {
                CreateProjectFromFilePlugin createProjectFromFilePlugin;
                Object t = clazz.newInstance();
                if (t instanceof CreateProjectFromFilePlugin && PluginUtilities.isSuitableCreateProjectFromFilePlugin(createProjectFromFilePlugin = (CreateProjectFromFilePlugin)t, string)) {
                    File file = new File(string2);
                    ArrayList arrayList = new ArrayList();
                    Project project = createProjectFromFilePlugin.createProject(file, arrayList);
                    if (!arrayList.isEmpty()) {
                        for (Object e : arrayList) {
                            System.err.println("Error with file " + string2 + ": " + e);
                        }
                    }
                    return project;
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Warning: Failed handle argument with " + clazz, exception);
            }
        }
        return null;
    }

    public static WelcomeDialog getWelcomeDialog() {
        return _welcome;
    }

    private static void restoreMainframeRectangle() {
        ApplicationProperties.restoreMainFrameProperties(_mainFrame);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Dimension dimension = _mainFrame.getSize();
        dimension.width = Math.min(dimension.width, rectangle.width);
        dimension.height = Math.min(dimension.height, rectangle.height);
        _mainFrame.setSize(dimension);
        Point point = _mainFrame.getLocation();
        point.x = Math.max(rectangle.x, point.x);
        point.y = Math.max(rectangle.y, point.y);
        _mainFrame.setLocation(point);
    }

    public static void main(final String[] stringArray) {
        ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Safe Thread Group"){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.getLogger().log(Level.SEVERE, "Uncaught Exception", throwable);
            }
        };
        Thread thread = new Thread(threadGroup, "Safe Main Thread"){

            public void run() {
                try {
                    Application.realmain(stringArray);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        SystemUtilities.sleepMsec(5000);
    }

    public static void realmain(String[] stringArray) {
        Application.initialize();
        _splashScreen = new SplashScreen();
        try {
            Application.init(stringArray);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "failed to initialize", exception);
        }
        _splashScreen.dispose();
        _splashScreen = null;
    }

    private static void parseOptions(String[] stringArray) {
    }

    public static void repaint() {
        if (_mainFrame != null) {
            _mainFrame.repaint();
        }
    }

    private static void showMainFrame() {
        _splashScreen.setVisible(false);
        _mainFrame.setVisible(true);
        ProjectManager.getProjectManager().bringErrorFrameToFront();
    }

    public static void shutdown() {
        _mainFrame.dispatchEvent(new WindowEvent(_mainFrame, 201));
    }
}

