/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.IncludedFrameLookup;
import edu.stanford.smi.protege.model.framestore.IncludingKBSupport;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueCachingNarrowFrameStore
implements NarrowFrameStore,
IncludingKBSupport {
    private Logger log = Log.getLogger(ValueCachingNarrowFrameStore.class);
    private DatabaseFrameDb _delegate;
    private final Sft _lookupSft = new Sft();
    private CacheMap _frameToSftToValuesMap = new CacheMap();
    private String frameDbName;
    private static final int LOAD_THRESHOLD = 10;

    public String getName() {
        return this._delegate.getName();
    }

    public void setName(String string) {
        this._delegate.setName(string);
    }

    public void close() {
        this._delegate.close();
        this._delegate = null;
        this._frameToSftToValuesMap = null;
    }

    public ValueCachingNarrowFrameStore(DatabaseFrameDb databaseFrameDb) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Constructing ValueCachingNarrowFrameStore with delegate " + databaseFrameDb);
        }
        this._delegate = databaseFrameDb;
    }

    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public DatabaseFrameDb getDelegate() {
        return this._delegate;
    }

    public FrameID generateFrameID() {
        return this._delegate.generateFrameID();
    }

    public Frame getFrame(FrameID frameID) {
        return this._delegate.getFrame(frameID);
    }

    private Map lookup(Frame frame) {
        return (Map)this._frameToSftToValuesMap.get(frame);
    }

    private List lookup(Map map, Slot slot, Facet facet, boolean bl) {
        this._lookupSft.set(slot, facet, bl);
        return (List)map.get(this._lookupSft);
    }

    private List lookup(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = null;
        Map map = this.lookup(frame);
        if (map != null) {
            list = this.lookup(map, slot, facet, bl);
        }
        return list;
    }

    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list;
        Map map = this.lookup(frame);
        if (map == null) {
            map = this.loadFrameIntoCache(frame);
        }
        if ((list = this.lookup(map, slot, facet, bl)) == null) {
            list = ValueCachingNarrowFrameStore.isSpecial(slot, facet, bl) ? this.loadSpecialValuesIntoCache(map, frame, slot, facet, bl) : Collections.EMPTY_LIST;
        }
        return list;
    }

    private static boolean isSpecial(Slot slot, Facet facet, boolean bl) {
        return facet == null && !bl && ValueCachingNarrowFrameStore.equals(slot, Model.SlotID.DIRECT_INSTANCES);
    }

    private static boolean equals(Slot slot, FrameID frameID) {
        return slot.getFrameID().equals(frameID);
    }

    private List loadSpecialValuesIntoCache(Map map, Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = this._delegate.getValues(frame, slot, facet, bl);
        this.insert(map, slot, null, false, list);
        return list;
    }

    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n;
        Map map = this.lookup(frame);
        if (map == null) {
            n = this.getDelegate().getValuesCount(frame, slot, facet, bl);
            if (n < 10) {
                map = this.loadFrameIntoCache(frame);
                this._frameToSftToValuesMap.put(frame, map);
            }
        } else {
            List list = this.lookup(map, slot, facet, bl);
            n = list == null ? this.getDelegate().getValuesCount(frame, slot, facet, bl) : list.size();
        }
        return n;
    }

    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.setValues(frame, slot, facet, bl, collection);
        this.setCacheValues(frame, slot, facet, bl, collection);
    }

    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.addValues(frame, slot, facet, bl, collection);
        this.addCacheValues(frame, slot, facet, bl, collection);
    }

    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this._delegate.removeValue(frame, slot, facet, bl, object);
        this.removeCacheValue(frame, slot, facet, bl, object);
    }

    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        ArrayList arrayList = new ArrayList(this.getValues(frame, slot, facet, bl));
        Object e = arrayList.remove(n);
        arrayList.add(n2, e);
        this._delegate.setValues(frame, slot, facet, bl, arrayList);
        this.moveCacheValue(frame, slot, facet, bl, n, n2);
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        return this._delegate.getFrames(slot, facet, bl, object);
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        return this._delegate.getFramesWithAnyValue(slot, facet, bl);
    }

    public Set getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        return this._delegate.getMatchingFrames(slot, facet, bl, string, n);
    }

    public Set getReferences(Object object) {
        return this._delegate.getReferences(object);
    }

    public Set getMatchingReferences(String string, int n) {
        return this._delegate.getMatchingReferences(string, n);
    }

    public void deleteFrame(Frame frame) {
        this.deleteCacheFrame(frame);
        this._delegate.deleteFrame(frame);
    }

    public Set executeQuery(Query query) {
        return this._delegate.executeQuery(query);
    }

    private void setCacheValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Map map = this.lookup(frame);
        if (map != null) {
            this.insert(map, slot, facet, bl, collection);
        }
    }

    private void insert(Map map, Slot slot, Facet facet, boolean bl, Collection collection) {
        if (collection == null) {
            this.remove(map, slot, facet, bl);
        } else {
            List list = this.lookup(map, slot, facet, bl);
            if (list == null) {
                map.put(new Sft(slot, facet, bl), new ArrayList(collection));
            } else {
                list.clear();
                list.addAll(collection);
            }
        }
    }

    private void remove(Map map, Slot slot, Facet facet, boolean bl) {
        this._lookupSft.set(slot, facet, bl);
        map.remove(this._lookupSft);
    }

    private void addCacheValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Map map = this.lookup(frame);
        if (map != null) {
            List list = this.lookup(map, slot, facet, bl);
            if (list == null) {
                if (!ValueCachingNarrowFrameStore.isSpecial(slot, facet, bl)) {
                    this.insert(map, slot, facet, bl, collection);
                }
            } else {
                list.addAll(collection);
            }
        }
    }

    private void removeCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        List list = this.lookup(frame, slot, facet, bl);
        if (list != null) {
            list.remove(object);
        }
    }

    private void moveCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        List list = this.lookup(frame, slot, facet, bl);
        if (list != null) {
            Object e = list.remove(n);
            list.add(n2, e);
        }
    }

    private void deleteCacheFrame(Frame frame) {
        this._frameToSftToValuesMap.remove(frame);
        for (Frame frame2 : this._frameToSftToValuesMap.getKeys()) {
            Map map = (Map)this._frameToSftToValuesMap.get(frame2);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                Sft sft = (Sft)entry.getKey();
                if (ValueCachingNarrowFrameStore.contains(sft, frame)) {
                    this._frameToSftToValuesMap.remove(frame2);
                    continue;
                }
                List list = (List)entry.getValue();
                list.remove(frame);
            }
        }
    }

    private static boolean contains(Sft sft, Frame frame) {
        return frame.equals(sft.getSlot()) || frame.equals(sft.getFacet());
    }

    private void loadFramesIntoCache() {
        this._frameToSftToValuesMap = null;
        SystemUtilities.gc();
        this._frameToSftToValuesMap = this._delegate.getFrameValues();
    }

    private Map loadFrameIntoCache(Frame frame) {
        Map map = this._delegate.getFrameValues(frame);
        this._frameToSftToValuesMap.put(frame, map);
        return map;
    }

    public boolean beginTransaction(String string) {
        return this.getDelegate().beginTransaction(string);
    }

    public boolean commitTransaction() {
        boolean bl = this.getDelegate().commitTransaction();
        if (!bl) {
            this.clearCache();
        }
        return bl;
    }

    public boolean rollbackTransaction() {
        boolean bl = this.getDelegate().rollbackTransaction();
        if (bl) {
            this.clearCache();
        }
        return bl;
    }

    public void clearCache() {
        this._frameToSftToValuesMap.clear();
    }

    public void replaceFrame(Frame frame) {
        this.clearCache();
        this.getDelegate().replaceFrame(frame);
    }

    private Set getCachedFrames() {
        return new HashSet(this._frameToSftToValuesMap.getKeys());
    }

    public Set getFrames() {
        Set set;
        int n = this.getFrameCount();
        Set set2 = this.getCachedFrames();
        if (set2.size() == n) {
            set = set2;
        } else {
            this.loadFramesIntoCache();
            set2 = this.getCachedFrames();
            set = set2.size() == n ? set2 : this.getDelegate().getFrames();
        }
        return set;
    }

    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    public void setIncludedFrames(IncludedFrameLookup includedFrameLookup) {
        if (this._delegate instanceof IncludingKBSupport) {
            ((IncludingKBSupport)((Object)this._delegate)).setIncludedFrames(includedFrameLookup);
        }
    }
}

