/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.prose;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProseGen {
    private static boolean checked = false;
    private static int indentLevel = 0;
    private static boolean includePreText = true;
    private static boolean insertNoTabs = false;
    private static boolean setTags = false;

    ProseGen() {
        indentLevel = 0;
    }

    private static String insertTabSpaces() {
        if (!setTags) {
            return "";
        }
        String retString = "";
        int i = 0;
        while (i < indentLevel) {
            retString = String.valueOf(retString) + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            ++i;
        }
        if (indentLevel > 0) {
            retString = String.valueOf(retString) + "<b><FONT size=4>-&nbsp;</FONT></b>";
        }
        return retString;
    }

    private static String makePluralIfNecessary(String inputStr) {
        if (!inputStr.toLowerCase().endsWith("s")) {
            return String.valueOf(inputStr) + "s";
        }
        return inputStr;
    }

    private static boolean isDemarcatingCharacter(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '<' && ch != '>' && ch != '/' && ch != '&' && ch != ';' && ch != '-';
    }

    private static boolean isDemarcatingCharacter(char prev, char ch, char next) {
        if (ProseGen.isDemarcatingCharacter(ch)) {
            return true;
        }
        return Character.isUpperCase(ch) && Character.isLowerCase(prev) && Character.isLowerCase(next);
    }

    private static boolean hasVowelStartChar(String word) {
        String tempWordInLower = word.toLowerCase().trim();
        return tempWordInLower.length() > 1 && (tempWordInLower.startsWith("a") || tempWordInLower.startsWith("e") || tempWordInLower.startsWith("i") || tempWordInLower.startsWith("o") || tempWordInLower.startsWith("u"));
    }

    private static String splitWordOnCapitals(String inputStr) {
        if ((inputStr = inputStr.trim()).length() > 0) {
            char[] chrArray = inputStr.toCharArray();
            String resultStr = "";
            String BufferStr = "";
            if (!ProseGen.isDemarcatingCharacter(chrArray[0])) {
                BufferStr = String.valueOf(BufferStr) + chrArray[0];
            }
            int index = 1;
            while (index < chrArray.length - 1) {
                char ch;
                if (ProseGen.isDemarcatingCharacter(chrArray[index - 1], chrArray[index], chrArray[index + 1]) && BufferStr != "") {
                    resultStr = String.valueOf(resultStr) + " " + BufferStr;
                    BufferStr = "";
                }
                if (!ProseGen.isDemarcatingCharacter(ch = chrArray[index])) {
                    BufferStr = String.valueOf(BufferStr) + ch;
                }
                ++index;
            }
            char ch = chrArray[chrArray.length - 1];
            if (!ProseGen.isDemarcatingCharacter(ch) && chrArray.length > 1) {
                BufferStr = String.valueOf(BufferStr) + ch;
            }
            if (resultStr != "") {
                resultStr = String.valueOf(resultStr) + " ";
            }
            resultStr = String.valueOf(resultStr) + BufferStr;
            return resultStr;
        }
        return "";
    }

    private static String getProseFromIntersectionCls(OWLIntersectionClass interCls) {
        Collection operands = interCls.getOperands();
        String retValString = "";
        if (insertNoTabs) {
            retValString = String.valueOf(retValString) + "The intersection of";
        } else if (!includePreText && indentLevel != 0) {
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
            includePreText = true;
        } else if (indentLevel > 0 && includePreText) {
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
        } else if (includePreText) {
            retValString = String.valueOf(retValString) + "The intersection of";
        }
        ++indentLevel;
        if (operands.size() == 1) {
            Iterator it = operands.iterator();
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + ((RDFSClass)it.next()).getBrowserText() + "</br>";
        }
        for (RDFSClass inputcls : operands) {
            if (!(inputcls instanceof OWLNamedClass || inputcls instanceof OWLIntersectionClass || inputcls instanceof OWLUnionClass)) {
                String proseStr = ProseGen.getProseFromCls(inputcls);
                if (proseStr.toLowerCase().startsWith("has")) {
                    retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "Any object that " + proseStr + "</br>";
                    continue;
                }
                if (proseStr.toLowerCase().startsWith("is")) {
                    retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + proseStr + "</br>";
                    continue;
                }
                if (proseStr == "") continue;
                retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "Any object where " + proseStr + "</br>";
                continue;
            }
            String proseFromCls = ProseGen.splitWordOnCapitals(ProseGen.getProseFromCls(inputcls)).trim();
            if (proseFromCls == "") continue;
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + proseFromCls + "</br>";
        }
        --indentLevel;
        return retValString;
    }

    private static String getProseFromUnionCls(OWLUnionClass interCls) {
        Collection operands = interCls.getOperands();
        String retValString = "";
        if (insertNoTabs) {
            retValString = String.valueOf(retValString) + "The union of";
        } else if (!includePreText && indentLevel != 0) {
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "The union of</br>";
            includePreText = true;
        } else if (indentLevel > 0 && includePreText) {
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
        } else if (includePreText) {
            retValString = String.valueOf(retValString) + "The union of";
        }
        ++indentLevel;
        if (operands.size() == 1) {
            Iterator it = operands.iterator();
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + ((RDFSClass)it.next()).getBrowserText() + "</br>";
        }
        for (RDFSClass inputcls : operands) {
            if (!(inputcls instanceof OWLNamedClass || inputcls instanceof OWLIntersectionClass || inputcls instanceof OWLUnionClass)) {
                String proseStr = ProseGen.getProseFromCls(inputcls);
                if (proseStr.toLowerCase().startsWith("has")) {
                    retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "Any object that " + proseStr + "</br>";
                    continue;
                }
                if (proseStr.toLowerCase().startsWith("is")) {
                    retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + proseStr + "</br>";
                    continue;
                }
                if (proseStr == "") continue;
                retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + "Any object where " + proseStr + "</br>";
                continue;
            }
            String proseFromCls = ProseGen.splitWordOnCapitals(ProseGen.getProseFromCls(inputcls)).trim();
            if (proseFromCls == "") continue;
            retValString = String.valueOf(retValString) + "<br>" + ProseGen.insertTabSpaces() + proseFromCls + "</br>";
        }
        --indentLevel;
        return retValString;
    }

    private static String getProseFromComplementCls(OWLComplementClass complementClass) {
        RDFSClass operand = complementClass.getComplement();
        String retValString = "";
        String proseFromCls = ProseGen.getProseFromCls(operand);
        if (proseFromCls.toLowerCase().startsWith("has")) {
            proseFromCls = proseFromCls.replaceFirst("has", "have");
            retValString = String.valueOf(retValString) + "Does not " + proseFromCls;
        } else {
            retValString = proseFromCls.toLowerCase().indexOf(" is ") > 0 ? String.valueOf(retValString) + proseFromCls.replaceAll(" is ", " is not ") : (!ProseGen.hasVowelStartChar(proseFromCls) ? String.valueOf(retValString) + "Is not a " + ProseGen.splitWordOnCapitals(proseFromCls) : String.valueOf(retValString) + "Is not an " + ProseGen.splitWordOnCapitals(proseFromCls));
        }
        return retValString;
    }

    private static String getProseFromMaxCardiRestriction(OWLMaxCardinality restrCls) {
        int value = restrCls.getCardinality();
        String restSlot = restrCls.getOnProperty().getName();
        String retValString = "";
        if (includePreText) {
            retValString = String.valueOf(retValString) + "the property ";
        }
        if (restSlot.toLowerCase().startsWith("has")) {
            String strArray = restSlot.substring(3);
            retValString = value == 1 || strArray.endsWith("s") ? "has at most " + value + " " + ProseGen.splitWordOnCapitals(strArray) : "has at most " + value + " " + ProseGen.splitWordOnCapitals(strArray) + "s";
        } else if (restSlot.toLowerCase().startsWith("is")) {
            String strArray = restSlot.toLowerCase().substring(2);
            retValString = "is " + ProseGen.splitWordOnCapitals(strArray) + " " + value;
        } else {
            retValString = value == 1 ? String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has at most " + value + " value" : String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has at most " + value + " values";
        }
        return retValString;
    }

    private static String getProseFromMinCardiRestriction(OWLMinCardinality restrCls) {
        int value = restrCls.getCardinality();
        String restSlot = restrCls.getOnProperty().getName();
        String retValString = "";
        if (includePreText) {
            retValString = String.valueOf(retValString) + "the property ";
        }
        if (restSlot.toLowerCase().startsWith("has")) {
            String strArray = restSlot.substring(3);
            retValString = value == 1 || strArray.endsWith("s") ? "has at least " + value + " " + ProseGen.splitWordOnCapitals(strArray) : "has at least " + value + " " + ProseGen.splitWordOnCapitals(strArray) + "s";
        } else {
            retValString = value == 1 ? String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has at least " + value + " value" : String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has at least " + value + " values";
        }
        return retValString;
    }

    private static String getProseFromCardiRestriction(OWLCardinality restrCls) {
        int value = restrCls.getCardinality();
        String restSlot = restrCls.getOnProperty().getName();
        String retValString = "";
        if (includePreText) {
            retValString = String.valueOf(retValString) + "the property ";
        }
        if (restSlot.toLowerCase().startsWith("has")) {
            String strArray = restSlot.substring(3);
            retValString = value == 1 || strArray.endsWith("s") ? "has exactly " + value + " " + ProseGen.splitWordOnCapitals(strArray) : "has exactly " + value + " " + ProseGen.splitWordOnCapitals(strArray) + "s";
        } else {
            retValString = value == 1 ? String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has exactly " + value + " value" : String.valueOf(retValString) + ProseGen.splitWordOnCapitals(restSlot) + " has exactly " + value + " values";
        }
        return retValString;
    }

    private static String getProseFromHasRestriction(OWLHasValue restrCls) {
        String slotName;
        Object hasValue = restrCls.getHasValue();
        String retValString = "";
        String browserText = hasValue instanceof RDFResource ? ((RDFResource)hasValue).getBrowserText() : hasValue.toString();
        RDFProperty restSlot = restrCls.getOnProperty();
        String testVar = slotName = restSlot.getName();
        if (slotName.toLowerCase().startsWith("has")) {
            String strArray = slotName.substring(3);
            retValString = browserText.equalsIgnoreCase("true") ? "has " + ProseGen.splitWordOnCapitals(strArray) : (browserText.equalsIgnoreCase("false") ? "has no " + ProseGen.splitWordOnCapitals(strArray) : "has " + ProseGen.splitWordOnCapitals(browserText) + " " + ProseGen.splitWordOnCapitals(strArray));
        } else if (slotName.toLowerCase().startsWith("is")) {
            String strArray = slotName.substring(2);
            retValString = browserText.equalsIgnoreCase("false") ? "is not " + ProseGen.splitWordOnCapitals(strArray) : (browserText.equalsIgnoreCase("true") ? "is " + ProseGen.splitWordOnCapitals(strArray) : "is " + ProseGen.splitWordOnCapitals(strArray) + " " + ProseGen.splitWordOnCapitals(browserText));
        } else {
            retValString = "the property " + ProseGen.splitWordOnCapitals(testVar) + " has value " + ProseGen.splitWordOnCapitals(browserText);
        }
        return retValString;
    }

    private static String generatePreText(RDFSClass inputClass, RDFSClass callingClass) {
        if (inputClass instanceof OWLIntersectionClass) {
            return "are";
        }
        if (inputClass instanceof OWLNamedClass) {
            if (callingClass instanceof OWLSomeValuesFrom) {
                return "is of type";
            }
            return "are of type";
        }
        if (inputClass instanceof OWLMaxCardinality) {
            return "must have at most";
        }
        if (inputClass instanceof OWLCardinality) {
            return "must be an object where";
        }
        if (inputClass instanceof OWLMinCardinality) {
            return "must be an object where";
        }
        if (inputClass instanceof OWLHasValue) {
            return "must be an object where";
        }
        if (inputClass instanceof OWLSomeValuesFrom) {
            return "must be an object where";
        }
        if (inputClass instanceof OWLAllValuesFrom) {
            return "must be an object where";
        }
        if (inputClass instanceof OWLEnumeratedClass) {
            return "are either";
        }
        if (inputClass instanceof OWLComplementClass) {
            return "must be an object that";
        }
        if (inputClass instanceof OWLUnionClass) {
            return "are";
        }
        return "";
    }

    private static String getProseFromSomeRestriction(OWLSomeValuesFrom restrCls) {
        String retValString = "";
        String browserText = "";
        String slotName = restrCls.getOnProperty().getName();
        RDFResource filler = restrCls.getFiller();
        if (!(filler instanceof RDFSClass)) {
            if (filler instanceof OWLDataRange) {
                OWLDataRange dataRange = (OWLDataRange)filler;
                RDFList oneOf = dataRange.getOneOf();
                if (oneOf != null) {
                    String strArray;
                    List values = oneOf.getValues();
                    Iterator it = values.iterator();
                    while (it.hasNext()) {
                        browserText = String.valueOf(browserText) + "\"" + it.next() + "\"";
                        if (!it.hasNext()) continue;
                        browserText = String.valueOf(browserText) + " or ";
                    }
                    if (values.size() == 0) {
                        retValString = "at least one of the values of the " + ProseGen.splitWordOnCapitals(slotName) + " property has no type";
                    } else if (slotName.toLowerCase().startsWith("has")) {
                        strArray = slotName.substring(3);
                        retValString = "at least one of the values has either " + ProseGen.splitWordOnCapitals(browserText) + " " + ProseGen.splitWordOnCapitals(strArray);
                    } else if (slotName.toLowerCase().startsWith("is")) {
                        strArray = slotName.substring(2);
                        retValString = "some of the values are " + ProseGen.splitWordOnCapitals(strArray) + " " + ProseGen.splitWordOnCapitals(browserText);
                    } else {
                        retValString = "at least one of the values of the " + ProseGen.splitWordOnCapitals(slotName) + " property is either " + ProseGen.splitWordOnCapitals(browserText);
                    }
                } else {
                    retValString = "no value";
                }
            } else {
                browserText = filler.getName();
                if (slotName.toLowerCase().startsWith("has")) {
                    String strArray = slotName.substring(3);
                    retValString = "at least one value has " + ProseGen.splitWordOnCapitals(browserText) + " " + ProseGen.splitWordOnCapitals(strArray);
                } else if (slotName.toLowerCase().startsWith("is")) {
                    String strArray = slotName.substring(2);
                    retValString = "some of the values are " + ProseGen.splitWordOnCapitals(strArray) + " " + ProseGen.splitWordOnCapitals(browserText);
                } else {
                    retValString = "at least one of the values of the " + ProseGen.splitWordOnCapitals(slotName) + " property is of type " + browserText;
                }
            }
        } else {
            RDFSClass someClass = (RDFSClass)filler;
            insertNoTabs = true;
            browserText = ProseGen.getProseFromCls(someClass);
            insertNoTabs = false;
            if (slotName.toLowerCase().startsWith("has")) {
                String strArray = slotName.substring(3);
                String tempString = ProseGen.splitWordOnCapitals(browserText);
                retValString = tempString.toLowerCase().endsWith("s") ? "has " + tempString + " as its " + ProseGen.splitWordOnCapitals(strArray) : "has " + (ProseGen.hasVowelStartChar(tempString) ? "an " : "a ") + tempString + " as its " + ProseGen.splitWordOnCapitals(strArray);
            } else if (slotName.toLowerCase().startsWith("is")) {
                String strArray = slotName.substring(2);
                retValString = "Some instances are " + ProseGen.splitWordOnCapitals(strArray) + " " + browserText;
            } else {
                retValString = "at least one of the values of the " + ProseGen.splitWordOnCapitals(slotName) + " property " + ProseGen.generatePreText(someClass, restrCls) + " " + ProseGen.splitWordOnCapitals(browserText);
            }
        }
        return retValString;
    }

    private static String getProseFromAllRestriction(OWLAllValuesFrom restrCls) {
        String browserText = "";
        String retValString = "";
        String slotName = restrCls.getOnProperty().getName();
        RDFResource filler = restrCls.getFiller();
        if (!(filler instanceof RDFSClass)) {
            if (filler instanceof OWLDataRange) {
                Object strArray;
                RDFList oneOf = ((OWLDataRange)filler).getOneOf();
                List values = oneOf == null ? Collections.EMPTY_LIST : oneOf.getValues();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    browserText = String.valueOf(browserText) + "\"" + it.next() + "\"";
                    if (!it.hasNext()) continue;
                    browserText = String.valueOf(browserText) + " or ";
                }
                if (slotName.toLowerCase().startsWith("has")) {
                    strArray = slotName.toLowerCase().split("has");
                    if (((String[])strArray).length > 1) {
                        retValString = "has " + browserText + " " + strArray[1];
                    }
                } else if (slotName.toLowerCase().startsWith("is")) {
                    strArray = slotName.toLowerCase().split("is");
                    if (((String[])strArray).length > 1) {
                        retValString = "is " + strArray[1] + " " + browserText;
                    }
                } else if (values.isEmpty()) {
                    retValString = "all values of the " + ProseGen.splitWordOnCapitals(slotName) + " property have no type";
                } else if (slotName.toLowerCase().startsWith("has")) {
                    strArray = slotName.substring(3);
                    retValString = "all values have either " + ProseGen.splitWordOnCapitals(browserText) + " " + ProseGen.splitWordOnCapitals((String)strArray);
                } else if (slotName.toLowerCase().startsWith("is")) {
                    strArray = slotName.substring(2);
                    retValString = "all instances are " + ProseGen.splitWordOnCapitals((String)strArray) + " " + ProseGen.splitWordOnCapitals(browserText);
                } else {
                    retValString = "all values of the " + ProseGen.splitWordOnCapitals(slotName) + " property are either " + ProseGen.splitWordOnCapitals(browserText);
                }
            } else {
                browserText = filler.getName();
                if (slotName.toLowerCase().startsWith("has")) {
                    String strArray = slotName.substring(3);
                    retValString = "all values have " + ProseGen.splitWordOnCapitals(browserText) + " " + ProseGen.splitWordOnCapitals(strArray);
                } else {
                    retValString = "all values of the " + ProseGen.splitWordOnCapitals(slotName) + " property are of type " + ProseGen.splitWordOnCapitals(browserText);
                }
            }
        } else {
            RDFSClass allClass = (RDFSClass)filler;
            insertNoTabs = true;
            browserText = ProseGen.getProseFromCls(allClass);
            insertNoTabs = false;
            if (slotName.toLowerCase().startsWith("has")) {
                String strArray = slotName.substring(3);
                retValString = "all " + ProseGen.makePluralIfNecessary(ProseGen.splitWordOnCapitals(strArray)) + " are " + ProseGen.splitWordOnCapitals(browserText);
            } else if (slotName.toLowerCase().startsWith("is")) {
                String strArray = slotName.substring(2);
                retValString = "All instances are " + ProseGen.splitWordOnCapitals(strArray) + " " + ProseGen.splitWordOnCapitals(browserText);
            } else {
                retValString = "all values of the " + ProseGen.splitWordOnCapitals(slotName) + " property " + ProseGen.generatePreText(allClass, restrCls) + " " + browserText;
            }
        }
        return retValString;
    }

    private static String getProseFromEnumerationCls(OWLEnumeratedClass enumCls) {
        Collection enumColl = enumCls.getOneOf();
        String retvalString = "";
        Iterator it = enumColl.iterator();
        while (it.hasNext()) {
            Instance inputcls = (Instance)it.next();
            retvalString = String.valueOf(retvalString) + inputcls.getName();
            if (!it.hasNext()) continue;
            retvalString = String.valueOf(retvalString) + " or ";
        }
        retvalString = String.valueOf(retvalString);
        return retvalString;
    }

    private static String getProseFromNamedCls(OWLNamedClass inputCls) {
        String browserText = inputCls.getBrowserText();
        if (browserText.split(":").length > 1) {
            browserText = browserText.split(":")[1];
        }
        String retvalString = "";
        if (!checked) {
            checked = true;
            retvalString = String.valueOf(retvalString) + browserText;
        } else if (browserText != null) {
            retvalString = String.valueOf(retvalString) + browserText;
        }
        return ProseGen.splitWordOnCapitals(retvalString).trim();
    }

    public static String getProseFromCls(RDFSClass inputClass) {
        String retval = "";
        if (inputClass instanceof OWLIntersectionClass) {
            retval = ProseGen.getProseFromIntersectionCls((OWLIntersectionClass)inputClass);
        } else if (inputClass instanceof OWLNamedClass) {
            retval = ProseGen.getProseFromNamedCls((OWLNamedClass)inputClass);
        } else if (inputClass instanceof OWLMaxCardinality) {
            retval = ProseGen.getProseFromMaxCardiRestriction((OWLMaxCardinality)inputClass);
        } else if (inputClass instanceof OWLCardinality) {
            retval = ProseGen.getProseFromCardiRestriction((OWLCardinality)inputClass);
        } else if (inputClass instanceof OWLMinCardinality) {
            retval = ProseGen.getProseFromMinCardiRestriction((OWLMinCardinality)inputClass);
        } else if (inputClass instanceof OWLHasValue) {
            retval = ProseGen.getProseFromHasRestriction((OWLHasValue)inputClass);
        } else if (inputClass instanceof OWLSomeValuesFrom) {
            retval = ProseGen.getProseFromSomeRestriction((OWLSomeValuesFrom)inputClass);
        } else if (inputClass instanceof OWLAllValuesFrom) {
            retval = ProseGen.getProseFromAllRestriction((OWLAllValuesFrom)inputClass);
        } else if (inputClass instanceof OWLEnumeratedClass) {
            retval = ProseGen.getProseFromEnumerationCls((OWLEnumeratedClass)inputClass);
        } else if (inputClass instanceof OWLComplementClass) {
            retval = ProseGen.getProseFromComplementCls((OWLComplementClass)inputClass);
        } else if (inputClass instanceof OWLUnionClass) {
            retval = ProseGen.getProseFromUnionCls((OWLUnionClass)inputClass);
        }
        return retval;
    }

    public static String getProseAsString(RDFSClass inputClass) {
        return ProseGen.getProseAsString(inputClass, true);
    }

    private static boolean isCapsBlock(char prev, char ch, char next) {
        return Character.isUpperCase(ch) && Character.isUpperCase(prev) || Character.isUpperCase(ch) && Character.isUpperCase(next);
    }

    private static String alterStringForNewLine(String inputStr) {
        int startindex = 0;
        int newIndex = 0;
        char[] tempArray = inputStr.toCharArray();
        while ((newIndex = inputStr.indexOf("<br>", startindex)) >= 0 && newIndex + 4 < inputStr.length()) {
            tempArray[newIndex + 4] = Character.toUpperCase(inputStr.charAt(newIndex + 4));
            startindex = newIndex + 1;
        }
        return new String(tempArray);
    }

    private static String changeCase(String inputString) {
        if (inputString.length() == 0) {
            return "";
        }
        char[] chrArray = inputString.toCharArray();
        String outputBuffer = "" + Character.toLowerCase(chrArray[0]);
        int index = 1;
        while (index < chrArray.length - 1) {
            outputBuffer = ProseGen.isCapsBlock(chrArray[index - 1], chrArray[index], chrArray[index + 1]) ? String.valueOf(outputBuffer) + chrArray[index] : String.valueOf(outputBuffer) + Character.toLowerCase(chrArray[index]);
            ++index;
        }
        if (chrArray.length > 1) {
            outputBuffer = String.valueOf(outputBuffer) + chrArray[chrArray.length - 1];
        }
        return ProseGen.alterStringForNewLine(outputBuffer);
    }

    public static String getProseAsString(RDFSClass inputClass, boolean sethtmlTags) {
        setTags = sethtmlTags;
        String result = "";
        indentLevel = 0;
        includePreText = true;
        if (inputClass instanceof OWLNamedClass) {
            if (inputClass.isSystem()) {
                return "";
            }
            Collection necessaryAndSufficientCol = inputClass.getEquivalentClasses();
            includePreText = false;
            int index = 1;
            Iterator iterator = necessaryAndSufficientCol.iterator();
            while (iterator.hasNext()) {
                Cls cls = (Cls)iterator.next();
                if (index == 1) {
                    result = "<html><b>Necessary and Sufficient Conditions:</b>";
                }
                if (index == 1 && iterator.hasNext() || index > 1) {
                    result = String.valueOf(result) + "<br><b>Condition Set: " + index + "</b></br>";
                }
                if (cls instanceof OWLIntersectionClass || cls instanceof OWLUnionClass || cls instanceof OWLComplementClass) {
                    if (iterator.hasNext() || index > 1) {
                        ++indentLevel;
                        result = String.valueOf(result) + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                        --indentLevel;
                    } else {
                        result = String.valueOf(result) + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                    }
                } else {
                    ++indentLevel;
                    result = String.valueOf(result) + "<br>" + ProseGen.insertTabSpaces() + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls)) + "</br>";
                    --indentLevel;
                }
                ++index;
            }
            if (result == "") {
                result = "<html>";
            }
            Collection necessaryCol = inputClass.getPureSuperclasses();
            index = 1;
            Iterator iterator2 = necessaryCol.iterator();
            while (iterator2.hasNext()) {
                Cls cls = (Cls)iterator2.next();
                if (index == 1) {
                    result = result.equalsIgnoreCase("<html>") ? String.valueOf(result) + "<b>Necessary Conditions:</b>" : String.valueOf(result) + "<br><b>Necessary Conditions:</b></br>";
                }
                if (cls instanceof OWLIntersectionClass || cls instanceof OWLUnionClass || cls instanceof OWLComplementClass) {
                    if (iterator2.hasNext() || index > 1) {
                        ++indentLevel;
                        result = String.valueOf(result) + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                        --indentLevel;
                    } else {
                        result = String.valueOf(result) + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                    }
                } else if (cls instanceof RDFSClass) {
                    ++indentLevel;
                    String dataBuffer = ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                    if (dataBuffer != "") {
                        result = String.valueOf(result) + "<br>" + ProseGen.insertTabSpaces() + dataBuffer + "</br>";
                    }
                    --indentLevel;
                }
                ++index;
            }
            if (index == 1) {
                result = String.valueOf(result);
            }
            result = result.equalsIgnoreCase("<html>") ? "" : String.valueOf(result) + "</html>";
        } else {
            result = ProseGen.getProseFromCls(inputClass);
            if ((result = ProseGen.changeCase(result)).length() > 0) {
                String subStr = result.substring(0, 1).toUpperCase();
                result = String.valueOf(subStr) + result.substring(1) + " ";
                if (setTags) {
                    result = "<HTML><p>" + result + "</p></HTML>";
                } else {
                    result = result.replaceAll("<br>", " ");
                    result = result.replaceAll("</br>", " ");
                    result = result.replaceAll("<b>", " ");
                    result = result.replaceAll("</b>", " ");
                }
            }
        }
        return result;
    }
}

