/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractLocalRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public class LocalFolderRepository
extends AbstractLocalRepository {
    private static transient Logger log = Log.getLogger(LocalFolderRepository.class);
    public static final String RECURSIVE_FLAG = "Recursive";
    private boolean recursive;

    public LocalFolderRepository(File folder) {
        this(folder, false);
    }

    public LocalFolderRepository(File folder, boolean forceReadOnly) {
        this(folder, forceReadOnly, false);
    }

    public LocalFolderRepository(File folder, boolean forceReadOnly, boolean recursive) {
        super(folder, forceReadOnly);
        this.recursive = recursive;
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.update();
    }

    private void update() {
        if (!this.getFile().isDirectory()) {
            if (ProtegeOWLParser.inUI) {
                System.out.println("[Local Folder Repository] The specified file must be a directory. (" + this.getFile() + ")");
            }
            return;
        }
        this.update(this.getFile());
    }

    private void update(File file) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (currentFile.isFile()) {
                try {
                    this.checkFile(currentFile);
                }
                catch (IOException e) {
                    Log.emptyCatchBlock((Throwable)e);
                }
            } else if (this.recursive && currentFile.isDirectory() && !currentFile.isHidden()) {
                this.update(currentFile);
            }
            ++i;
        }
    }

    private void checkFile(File file) throws IOException {
        if (file.getName().endsWith(".owl") && file.isFile()) {
            FileInputStream is = new FileInputStream(file);
            file.toURL();
            OntologyNameExtractor extractor = new OntologyNameExtractor(is, file.toURI().toURL());
            if (extractor.getOntologyName() != null) {
                URI name = extractor.getOntologyName();
                this.putOntology(name, file);
            }
        }
    }

    public String getRepositoryDescriptor() {
        String descriptor = super.getRepositoryDescriptor();
        if (descriptor != null) {
            descriptor = String.valueOf(descriptor) + "&Recursive=" + Boolean.toString(this.recursive);
        }
        return descriptor;
    }

    public String getRepositoryDescription() {
        String description = "Local folder ";
        description = String.valueOf(description) + this.getFile().getPath();
        return description;
    }
}

