/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.multiresource.MultiResourceList;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiResourceComponent
extends AddablePropertyValuesComponent {
    private Action createAction;
    private MultiResourceList list;
    private Action removeAction = new AbstractAction("Remove selected values", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            MultiResourceComponent.this.handleRemove();
        }
    };

    public MultiResourceComponent(RDFProperty predicate, boolean symmetric) {
        super(predicate);
        AddResourceAction addAction;
        this.list = new MultiResourceList(predicate, symmetric);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MultiResourceComponent.this.updateActions();
            }
        });
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), new JScrollPane((Component)((Object)this.list)));
        this.createAction = this.createCreateAction();
        if (this.createAction != null) {
            lc.addHeaderButton(this.createAction);
        }
        if ((addAction = this.createAddAction(symmetric)) != null) {
            lc.addHeaderButton(addAction);
        }
        lc.addHeaderButton(this.removeAction);
        this.add("Center", (Component)((Object)lc));
        this.updateActions();
    }

    protected AddResourceAction createAddAction(boolean symmetric) {
        return new AddResourceAction(this, symmetric);
    }

    protected Action createCreateAction() {
        return new AbstractAction("Create new resource...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            public void actionPerformed(ActionEvent e) {
                MultiResourceComponent.this.list.handleCreate();
            }
        };
    }

    protected Object[] getSelectedObjects() {
        return this.list.getSelectedValues();
    }

    protected void handleRemove() {
        this.list.handleRemove();
    }

    public boolean isCreateEnabled() {
        return !this.isEnumerationProperty();
    }

    public void setSubject(RDFResource subject) {
        super.setSubject(subject);
        this.list.getListModel().setSubject(subject);
        this.updateActions();
    }

    public void valuesChanged() {
        this.list.getListModel().updateValues();
    }

    private void updateActions() {
        if (this.createAction != null) {
            this.createAction.setEnabled(this.isCreateEnabled());
        }
        this.removeAction.setEnabled(this.list.isRemoveEnabled());
    }
}

