/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFolderRepository;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RelativeURLSpecificationWizardPanel
extends RepositoryCreatorWizardPanel {
    private JTextField textField;
    private JCheckBox forceReadOnlyCheckBox;
    private OWLModel model;
    private WizardPage wizardPage;
    private static final String HELP_TEXT = "<p>Please specify a relative <b>URL</b> that points to a folder containing ontologies.</p><p>The URL should be relative to the folder containing the pprj/owl file.  For example if the pprj/owl file is located at /Users/mrowl/documents/ontologies/myOnt.owl, the relative URL ./../ontlibrary would specify the ontlibrary folder in the parent folder of /Users/mrowl/documents/ontologies i.e. /Users/mrowl/documents/ontlibrary</p><p>Note that the path separator for URLs is the forward slash '/', and spaces must be replaced with \"%20\".</p>";

    public RelativeURLSpecificationWizardPanel(WizardPage wizardPage, OWLModel model) {
        this.model = model;
        this.wizardPage = wizardPage;
        this.setLayout(new BorderLayout(7, 7));
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                RelativeURLSpecificationWizardPanel.this.updateWizardPageState();
            }

            public void removeUpdate(DocumentEvent e) {
                RelativeURLSpecificationWizardPanel.this.updateWizardPageState();
            }

            public void changedUpdate(DocumentEvent e) {
                RelativeURLSpecificationWizardPanel.this.updateWizardPageState();
            }
        });
        JPanel holderPanel = new JPanel(new BorderLayout(3, 3));
        LabeledComponent lc = new LabeledComponent("Relative URL", (Component)this.textField);
        holderPanel.add((Component)lc, "North");
        this.forceReadOnlyCheckBox = new JCheckBox("Force Read-Only");
        holderPanel.add((Component)this.forceReadOnlyCheckBox, "South");
        this.add((Component)holderPanel, "North");
        this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, null, 160), "South");
        this.updateWizardPageState();
    }

    private void updateWizardPageState() {
        this.wizardPage.setPageComplete(this.validateData());
    }

    public Repository createRepository() {
        try {
            return new RelativeFolderRepository(this.getBaseURL(), this.textField.getText().trim(), this.forceReadOnlyCheckBox.isSelected());
        }
        catch (Exception e) {
            return null;
        }
    }

    private URL getBaseURL() {
        try {
            URI projectURI = this.model.getProject().getProjectURI();
            File f = new File(projectURI).getParentFile();
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean validateData() {
        if (this.textField.getText().trim().length() == 0) {
            return false;
        }
        try {
            URL baseURL = this.getBaseURL();
            URL url = new URL(baseURL, this.textField.getText().trim());
            File f = new File(new URI(url.toString()));
            boolean exists = f.exists();
            return exists;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

