/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AddTodoAction;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTable;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.CreateValueAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;

public class AnnotationsComponent
extends AbstractTriplesComponent {
    private Action deleteRowAction;

    public AnnotationsComponent(RDFProperty predicate) {
        super(predicate, "Annotations", OWLIcons.getImageIcon("AnnotationsTable"));
    }

    protected void addButtons(LabeledComponent lc) {
        lc.addHeaderButton((Action)new CreateValueAction(this.getTable(), "Create new annotation value", OWLIcons.getCreateIcon("Annotation")){

            public Collection getSelectableResources() {
                TriplesTableModel tableModel = this.table.getTableModel();
                OWLModel owlModel = tableModel.getOWLModel();
                ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
                Collection annotationProperties = owlModel.getOWLAnnotationProperties();
                Collection ontologyProperties = owlModel.getOWLOntologyProperties();
                RDFResource resource = tableModel.getSubject();
                for (RDFProperty property : annotationProperties) {
                    if (ontologyProperties.contains(property)) {
                        if (!(resource instanceof OWLOntology)) continue;
                        properties.add(property);
                        continue;
                    }
                    RDFSClass type = resource.getProtegeType();
                    Collection domainProperties = type.getUnionDomainProperties(true);
                    if (!domainProperties.contains(property)) continue;
                    boolean zero = resource.getPropertyValues(property, true).isEmpty();
                    if (property.isFunctional() && !zero) continue;
                    properties.add(property);
                }
                return properties;
            }
        });
        lc.addHeaderButton((Action)new AddTodoAction((AnnotationsTable)this.getTable()));
        lc.addHeaderButton((Action)new AddResourceAction(this.getTable()){

            protected Collection getAllowedProperties(OWLModel owlModel) {
                return owlModel.getOWLAnnotationProperties();
            }
        });
        this.deleteRowAction = new DeleteTripleAction(this.getTable(), "Delete selected annotation", OWLIcons.getDeleteIcon("Annotation"));
        this.deleteRowAction.setEnabled(false);
        lc.addHeaderButton(this.deleteRowAction);
    }

    protected TriplesTable createTable(Project project) {
        return new AnnotationsTable(project, (AnnotationsTableModel)this.getTableModel());
    }

    protected TriplesTableModel createTableModel() {
        return new AnnotationsTableModel();
    }

    protected void updateActions() {
        super.updateActions();
        int row = this.getTable().getSelectedRow();
        TriplesTableModel tableModel = this.getTable().getTableModel();
        boolean deleteRowEnabled = false;
        if (row >= 0) {
            deleteRowEnabled = tableModel.isDeleteEnabled(row);
        }
        this.deleteRowAction.setEnabled(deleteRowEnabled);
    }
}

