/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesTable;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class UnionRangeClassesComponent
extends JComponent {
    private OWLModel owlModel;
    private UnionRangeClassesTable table;
    private UnionRangeClassesTableModel tableModel;
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Specialise Range", OWLIcons.getAddIcon("PrimitiveClass"), true){

        public void resourceSelected(RDFResource resource) {
            Collection clses;
            Collection dd;
            OWLModel owlModel;
            RDFSClass classToAdd = (RDFSClass)resource;
            if (classToAdd.equals(resource.getOWLModel().getOWLThingClass())) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(UnionRangeClassesComponent.this.owlModel, "The class " + classToAdd.getBrowserText() + " cannot be added to the range.\n" + "Please set the range to empty to get this behavior.", "Invalid Class");
                return;
            }
            RDFProperty property = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            if (!(property instanceof OWLProperty) && !ProfilesManager.isFeatureSupported(owlModel = property.getOWLModel(), OWLProfiles.Union_Classes) && (dd = property.getUnionRangeClasses()).size() > 0 && property.getRange(false) != null) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "In pure RDF, rdf:Properties can only have one class in their\n(union) range.  You need to select a different language profile.");
                return;
            }
            if (property.getSuperpropertyCount() > 0 && (clses = UnionRangeClassesComponent.this.getUnionRangeClassesOfSuperproperties()).size() > 0) {
                boolean one = false;
                for (RDFSClass cls : clses) {
                    if (!cls.equals(resource) && !classToAdd.getSuperclasses(true).contains(cls)) continue;
                    one = true;
                }
                if (!one) {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(UnionRangeClassesComponent.this.owlModel, "The class " + classToAdd.getBrowserText() + " cannot be added to the range\n" + "of " + property.getBrowserText() + " because it does not narrow the classes\n" + "from the range of its super-properties.");
                    return;
                }
            }
            UnionRangeClassesComponent.this.tableModel.addRow(classToAdd, UnionRangeClassesComponent.this.table.getSelectedRow());
        }

        public Collection getSelectableResources() {
            RDFProperty property = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            Collection<Cls> clses = new HashSet();
            Collection allowedClses = property.getUnionRangeClasses();
            OWLNamedClass rootCls = property.getOWLModel().getOWLThingClass();
            if (property.getSuperpropertyCount() > 0 && !allowedClses.isEmpty() && !allowedClses.contains(rootCls)) {
                for (Cls cls : allowedClses) {
                    clses.add(cls);
                    clses.addAll(cls.getSubclasses());
                }
                Slot valueTypeSlot = property.getOWLModel().getSlot(":SLOT-VALUE-TYPE");
                clses.removeAll(property.getDirectOwnSlotValues(valueTypeSlot));
            } else {
                clses = OWLUtil.getSelectableNamedClses(UnionRangeClassesComponent.this.owlModel);
                OWLNamedClass editedCls = UnionRangeClassesComponent.this.tableModel.getEditedCls();
                clses.remove(editedCls);
                clses.removeAll(UnionRangeClassesComponent.this.tableModel.getValues());
            }
            clses.remove(rootCls);
            Object[] cs = clses.toArray();
            Arrays.sort(cs, new FrameComparator());
            return Arrays.asList(cs);
        }

        public Collection pickResources() {
            RDFSNamedClass rdfsClass = UnionRangeClassesComponent.this.owlModel.getRDFSNamedClassClass();
            boolean rdfsClassWasVisible = rdfsClass.isVisible();
            OWLNamedClass owlClass = UnionRangeClassesComponent.this.owlModel.getOWLNamedClassClass();
            boolean owlClassWasVisible = owlClass.isVisible();
            if (!rdfsClassWasVisible && ProfilesManager.isFeatureSupported(UnionRangeClassesComponent.this.owlModel, OWLProfiles.OWL_Full)) {
                rdfsClass.setVisible(true);
                owlClass.setVisible(true);
            }
            RDFProperty property = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            HashSet<OWLNamedClass> rootClasses = new HashSet<OWLNamedClass>();
            rootClasses.add(UnionRangeClassesComponent.this.owlModel.getOWLThingClass());
            if (property.getSuperpropertyCount() > 0) {
                for (RDFProperty superProp : property.getSuperproperties(true)) {
                    rootClasses.addAll(superProp.getRanges(false));
                }
                if (rootClasses.size() > 1) {
                    rootClasses.remove(UnionRangeClassesComponent.this.owlModel.getOWLThingClass());
                }
            }
            Set results = ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)UnionRangeClassesComponent.this.table), UnionRangeClassesComponent.this.owlModel, rootClasses, "Select named class(es) to add");
            rdfsClass.setVisible(rdfsClassWasVisible);
            owlClass.setVisible(owlClassWasVisible);
            return results;
        }
    };
    private Action createAction = new AbstractAction("Specialise Range using OWL expression", OWLIcons.getCreateIcon("OWLAnonymousClass")){

        public void actionPerformed(ActionEvent e) {
            UnionRangeClassesComponent.this.table.createAndEditRow();
        }
    };
    private OWLTableAction deleteAction = new AbstractOWLTableAction("Remove from Range", OWLIcons.getRemoveIcon("PrimitiveClass")){

        public void actionPerformed(ActionEvent e) {
            OWLTableModel tableModel;
            int selIndex = UnionRangeClassesComponent.this.table.getSelectedRow();
            if (selIndex >= 0 && (tableModel = (OWLTableModel)UnionRangeClassesComponent.this.table.getModel()).isCellEditable(selIndex, tableModel.getSymbolColumnIndex())) {
                tableModel.deleteRow(selIndex);
                UnionRangeClassesComponent.this.table.getSelectionModel().setSelectionInterval(selIndex, selIndex);
            }
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return cls != null && UnionRangeClassesComponent.this.tableModel.isDeleteEnabledFor(cls);
        }
    };
    private OWLTableAction viewAction = new AbstractOWLTableAction("View class", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            Cls cls = UnionRangeClassesComponent.this.table.getSelectedCls();
            UnionRangeClassesComponent.this.table.getOWLModel().getProject().show((Instance)cls);
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return cls instanceof RDFSNamedClass;
        }
    };

    public UnionRangeClassesComponent(OWLModel owlModel, PropertyWidget propertyWidget) {
        this.owlModel = owlModel;
        this.tableModel = new UnionRangeClassesTableModel(propertyWidget);
        this.table = new UnionRangeClassesTable(this.tableModel, owlModel);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        this.table.registerAction(this.viewAction);
        this.table.registerAction(this.deleteAction);
        OWLLabeledComponent lc = new OWLLabeledComponent("Range  \u2294", scrollPane, true, false);
        WidgetUtilities.addViewButton(lc, this.viewAction);
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.OWL_Lite)) {
            lc.addHeaderButton(this.createAction);
        }
        lc.addHeaderButton(this.addAction);
        lc.addHeaderButton(this.deleteAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
    }

    private Collection getUnionRangeClassesOfSuperproperties() {
        HashSet result = new HashSet();
        for (RDFProperty superproperty : this.tableModel.getEditedProperty().getSuperproperties(true)) {
            result.addAll(superproperty.getUnionRangeClasses());
        }
        return result;
    }

    public void dispose() {
        ((OWLTableModel)this.table.getModel()).dispose();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setEditable(boolean b) {
        super.setEnabled(b);
        if (this.getComponentCount() > 0) {
            LabeledComponent lc = (LabeledComponent)this.getComponent(0);
            for (Action action : lc.getHeaderButtonActions()) {
                action.setEnabled(b);
            }
            this.table.setEnabled(b);
            this.table.enableActions();
        }
    }

    public void refill() {
        this.table.hideSymbolPanel();
        this.tableModel.refill();
    }
}

